/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import io.imply.cloud.Constants;
import io.imply.cloud.util.IAE;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class K8sIngestionUtils {
    private static final Pattern TEMPLATE_PATH_PATTERN = Pattern.compile(".*/([^/]+)-peon-config.yaml");

    public static String tierNumberToPeonPodTemplatePath(Integer tierNumber) {
        if (tierNumber == 0) {
            return "druid/overlord/base-peon-config.yaml";
        }
        return String.format("druid/overlord/%s-peon-config.yaml", tierNumber);
    }

    public static Integer tierNumberFromPeonPodTemplatePath(String peonPodTemplatePath) {
        Matcher matcher = TEMPLATE_PATH_PATTERN.matcher(peonPodTemplatePath);
        if (matcher.matches()) {
            return "base".equals(matcher.group(1)) ? Constants.DEFAULT_PEON_TEMPLATE_TIER : Integer.parseInt(matcher.group(1));
        }
        throw new IAE("Invalid peon pod template path %s", peonPodTemplatePath);
    }

    public static String getConfigMapNameForTierAndWorkerVersion(Integer instanceTier, String workerVersion) {
        String suffix = instanceTier == 0 ? K8sIngestionUtils.generateConfigMapSuffix(workerVersion) : String.format("-%s", instanceTier) + K8sIngestionUtils.generateConfigMapSuffix(workerVersion);
        return "peon-configs" + suffix;
    }

    public static String getEnvVariableSecretsForTier(Integer instanceTier) {
        String suffix = instanceTier == 0 ? "" : String.format("-%s", instanceTier);
        return "peon-environment-variable-secrets" + suffix;
    }

    public static String generateConfigMapSuffix(String workerVersion) {
        return String.format("-%s", workerVersion);
    }
}

