/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.inject.Inject;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.util.ISE;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;

@LazySingleton
public class InstanceTypeHelper {
    private final RefreshableConstants refreshableConstants;

    public InstanceType lookupInstanceType(ImplyNodeType nodeType, String instanceType) {
        List<InstanceType> instanceTypes = this.getSupportedInstanceTypes(nodeType);
        return instanceTypes.stream().filter(x -> x.getInstanceType().equals(instanceType)).findFirst().orElseThrow(() -> new ISE("Unable to lookup instance type [%s]", instanceType));
    }

    public List<InstanceType> lookupInstanceTypes(ImplyNodeType nodeType, Predicate<InstanceType> predicate) {
        return this.getSupportedInstanceTypes(nodeType).stream().filter(predicate).collect(Collectors.toList());
    }

    public String getDefaultInstanceTypeForNodeType(ImplyNodeType nodeType) {
        return this.getDefaultInstanceTypeForNodeType(nodeType, (Account)Account.builder().build());
    }

    public String getDefaultInstanceTypeForNodeType(ImplyNodeType nodeType, Account account) {
        return this.filterInstanceTypes(this.getSupportedInstanceTypes(nodeType), account);
    }

    public String getDefaultInstanceTypeForMetadata(Account account) {
        return this.filterInstanceTypes(this.refreshableConstants.getSupportedDbInstanceTypes(), account);
    }

    private String filterInstanceTypes(List<InstanceType> nodes, Account account) {
        return nodes.stream().filter(x -> x.isImplyInternalInstanceDefault() && FeatureFlag.enabledForAccount(account, "_implyInternalInstanceDefaults_") || x.isPreferredDefault() || x.isFallbackDefault()).sorted(Comparator.comparing(InstanceType::isFallbackDefault).thenComparing(InstanceType::isPreferredDefault).thenComparing(InstanceType::isImplyInternalInstanceDefault)).findFirst().map(InstanceType::getInstanceType).orElse(null);
    }

    public List<InstanceType> getSupportedInstanceTypes(ImplyNodeType nodeType) {
        return switch (nodeType.getNodeServiceType()) {
            case ImplyNodeType.ImplyNodeServiceType.MASTER -> this.refreshableConstants.getSupportedMasterInstanceTypes();
            case ImplyNodeType.ImplyNodeServiceType.QUERY, ImplyNodeType.ImplyNodeServiceType.COLD_TIER_QUERY -> this.refreshableConstants.getSupportedQueryInstanceTypes();
            case ImplyNodeType.ImplyNodeServiceType.DATA, ImplyNodeType.ImplyNodeServiceType.COLD_TIER_DATA -> this.refreshableConstants.getSupportedDataInstanceTypes();
            default -> throw new ISE("Unsupported nodeType [%s]", nodeType);
        };
    }

    public Integer getZookeeperHeapSize(InstanceType instanceType) {
        if (instanceType == null) {
            return 512;
        }
        if (instanceType.getZkHeap() != null) {
            return instanceType.getZkHeap();
        }
        int memory = (Integer)ObjectUtils.defaultIfNull((Object)instanceType.getMemoryInGb(), (Object)0);
        return (int)Math.max(Math.ceil((double)memory / 16.0) * 512.0, 512.0);
    }

    @Inject
    @Generated
    public InstanceTypeHelper(RefreshableConstants refreshableConstants) {
        this.refreshableConstants = refreshableConstants;
    }
}

