/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.inject.Inject;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.persistence.ClusterDataManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class ImplyVersionHelper {
    private final DefaultsConfig defaultsConfig;
    private final RefreshableConstants refreshableConstants;

    @Inject
    public ImplyVersionHelper(DefaultsConfig defaultsConfig, RefreshableConstants refreshableConstants) {
        this.defaultsConfig = defaultsConfig;
        this.refreshableConstants = refreshableConstants;
    }

    public List<ImplyVersion> getSupportedImplyVersionsIncludingAccountVersions(String accountId, ClusterDataManager clusterDataManager) {
        ArrayList<ImplyVersion> implyVersions = new ArrayList<ImplyVersion>();
        implyVersions.addAll(ListUtils.emptyIfNull(this.defaultsConfig.getCustomImplyVersions()));
        implyVersions.addAll(this.refreshableConstants.getSupportedImplyVersions().stream().filter(x -> !x.isHidden() || x.getVisibilityWhitelist() != null && x.getVisibilityWhitelist().contains(accountId)).collect(Collectors.toList()));
        if (accountId != null) {
            List<Cluster> clusters = clusterDataManager.getAllWithAccountId(accountId);
            for (Cluster cluster : clusters) {
                if (cluster.getImplyVersionFull() == null || cluster.getImplyVersionFull().getVersion() == null || !implyVersions.stream().noneMatch(x -> cluster.getImplyVersionFull().getVersion().equals(x.getVersion()))) continue;
                implyVersions.add(cluster.getImplyVersionFull());
            }
        }
        return implyVersions;
    }

    public ImplyVersion lookupImplyVersionIncludingAccountVersions(String version, String accountId, ClusterDataManager clusterDataManager) {
        ImplyVersion implyVersion = ListUtils.emptyIfNull(this.defaultsConfig.getCustomImplyVersions()).stream().filter(x -> version.equals(x.getVersion())).findFirst().orElseGet(() -> this.refreshableConstants.lookupImplyVersion(version));
        if (implyVersion != null && (!implyVersion.isHidden() || implyVersion.getVisibilityWhitelist() != null && implyVersion.getVisibilityWhitelist().contains(accountId))) {
            return implyVersion;
        }
        if (accountId != null) {
            List<Cluster> clusters = clusterDataManager.getAllWithAccountId(accountId);
            for (Cluster cluster : clusters) {
                if (cluster.getImplyVersionFull() == null || !cluster.getImplyVersionFull().getVersion().equals(version)) continue;
                return cluster.getImplyVersionFull();
            }
        }
        return null;
    }

    public static ImplyVersion getDefaultVersion(List<ImplyVersion> versions) {
        return versions.stream().filter(ImplyVersion::isDefaultVersion).findFirst().orElseGet(() -> !versions.isEmpty() ? (ImplyVersion)versions.get(0) : null);
    }

    public ImplyVersion getDefaultVersion() {
        return ImplyVersionHelper.getDefaultVersion(this.refreshableConstants.getSupportedImplyVersions());
    }
}

