/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Collection;
import org.bouncycastle.util.io.pem.PemReader;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class ImplyLicenseGenerator {
    private final ObjectMapper mapper;
    private final Provider<DateTime> currentDateTimeProvider;
    private final PrivateKey privateKey;

    @Inject
    public ImplyLicenseGenerator(ObjectMapper mapper, Provider<DateTime> currentDateTimeProvider) {
        this.mapper = mapper;
        this.currentDateTimeProvider = currentDateTimeProvider;
        try (PemReader in = new PemReader((Reader)new InputStreamReader(ImplyLicenseGenerator.class.getClassLoader().getResourceAsStream("pivot-key.pem")));){
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(in.readPemObject().getContent());
            this.privateKey = KeyFactory.getInstance("RSA").generatePrivate(spec);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String generate(String name, DateTime expiry, Collection<String> features) {
        try {
            String payload = String.format("%s|%s", this.mapper.writeValueAsString((Object)ImmutableMap.of((Object)"name", (Object)name, (Object)"expiryDate", (Object)ISODateTimeFormat.date().print((ReadableInstant)expiry), (Object)"features", features)), ISODateTimeFormat.date().print((ReadableInstant)this.currentDateTimeProvider.get()));
            return String.format("%s|%s", payload, this.sign(payload));
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String generate(String name, DateTime expiry, String ... features) {
        return this.generate(name, expiry, (Collection<String>)ImmutableList.copyOf((Object[])features));
    }

    private String sign(String data) {
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(this.privateKey);
            signature.update(data.getBytes());
            return Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

