/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import io.imply.cloud.exception.ValidationException;
import io.imply.cloud.util.Logger;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpMethod;

public class HttpUtil {
    private static final Logger log = new Logger(HttpUtil.class);
    private static final int HTTP_TIMEOUT_IN_SECONDS = 15;

    public static void validateHttpPathsExist(HttpClient httpClient, Set<String> paths) {
        for (String fetchablePath : paths) {
            if (!fetchablePath.toLowerCase().startsWith("http://") && !fetchablePath.toLowerCase().startsWith("https://")) continue;
            log.info("Testing HTTP(S) path [%s]", fetchablePath);
            Response response = null;
            try {
                InputStreamResponseListener listener = new InputStreamResponseListener();
                httpClient.newRequest(fetchablePath).method(HttpMethod.HEAD).timeout(15L, TimeUnit.SECONDS).send((Response.CompleteListener)listener);
                response = listener.get(15L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new ValidationException("Unable to fetch path [%s], exception: [%s]", fetchablePath, e.getMessage());
            }
            finally {
                if (response != null) {
                    response.abort((Throwable)new RuntimeException());
                }
            }
            if (response != null && response.getStatus() / 100 == 2) continue;
            throw new ValidationException("Unable to fetch path [%s], responseCode [%s]", fetchablePath, response == null ? "null" : Integer.valueOf(response.getStatus()));
        }
    }
}

