/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import io.imply.cloud.model.DataUnitType;
import io.imply.cloud.util.InstanceTypeHelper;

public class DiskSizeUtils {
    public static final Integer REPLICATION_FACTOR = 2;

    public static Integer getCPUToDiskGBRatioFromDisk(Integer storagePerPodWithOverhead, DataUnitType dataUnit, InstanceTypeHelper instanceTypeHelper) {
        Integer storagePerPod = Math.round((float)storagePerPodWithOverhead.intValue() * DiskSizeUtils.getOverheadPercentage(dataUnit, instanceTypeHelper));
        Integer totalReplicatedStorage = storagePerPod * dataUnit.getTotalInstanceCount();
        Integer totalStorage = totalReplicatedStorage / REPLICATION_FACTOR;
        Integer cpuToDiskGBRatio = totalStorage / dataUnit.getCpu(instanceTypeHelper);
        return cpuToDiskGBRatio;
    }

    public static Integer getDiskFromCPUToDiskGBRatio(Integer cpuToDiskGBRatio, DataUnitType dataUnitType, InstanceTypeHelper instanceTypeHelper) {
        Integer totalStorage = cpuToDiskGBRatio * dataUnitType.getCpu(instanceTypeHelper);
        Integer totalReplicatedStorage = totalStorage * REPLICATION_FACTOR;
        Integer storagePerPod = totalReplicatedStorage / dataUnitType.getTotalInstanceCount();
        Integer storagePerPodWithOverhead = Math.round((float)storagePerPod.intValue() / DiskSizeUtils.getOverheadPercentage(dataUnitType, instanceTypeHelper));
        return storagePerPodWithOverhead;
    }

    public static float getOverheadPercentage(DataUnitType dataUnit, InstanceTypeHelper instanceTypeHelper) {
        Integer storageFactor = dataUnit.getCpu(instanceTypeHelper) * REPLICATION_FACTOR / dataUnit.getTotalInstanceCount();
        if (storageFactor % 8 == 0) {
            return 0.8888889f;
        }
        if (storageFactor % 4 == 0) {
            return 0.8f;
        }
        if (storageFactor % 2 == 0) {
            return 0.6666667f;
        }
        return 0.5f;
    }
}

