/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import io.imply.cloud.model.Mergeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DiffUtils {
    private DiffUtils() {
    }

    public static <T> T defaultIfNull(T value) {
        return value;
    }

    public static <T> List<T> defaultIfNull(List<T> value) {
        if (value != null) {
            return value;
        }
        return Collections.emptyList();
    }

    public static <K, V> Map<K, V> defaultIfNull(Map<K, V> value) {
        if (value != null) {
            return value;
        }
        return Collections.emptyMap();
    }

    public static <T> T nullIf(T first, T second) {
        return DiffUtils.nullIf(first, second, false);
    }

    public static <T> T nullIfElseDefault(T first, T second) {
        return DiffUtils.nullIf(first, second, true);
    }

    public static <T> T nullIf(T first, T second, boolean defaultValue) {
        if (Objects.equals(first, second)) {
            return null;
        }
        return defaultValue ? DiffUtils.defaultIfNull(first) : first;
    }

    public static <T> List<T> nullIf(List<T> first, List<T> second) {
        return DiffUtils.nullIf(first, second, false);
    }

    public static <T> List<T> nullIfElseDefault(List<T> first, List<T> second) {
        return DiffUtils.nullIf(first, second, true);
    }

    public static <T> List<T> nullIf(List<T> first, List<T> second, boolean defaultValue) {
        if (Objects.equals(first, second)) {
            return null;
        }
        if (first == null && second != null && second.isEmpty()) {
            return null;
        }
        if (second == null && first != null && first.isEmpty()) {
            return null;
        }
        return defaultValue ? DiffUtils.defaultIfNull(first) : first;
    }

    public static <K, V> Map<K, V> nullIf(Map<K, V> first, Map<K, V> second) {
        return DiffUtils.nullIf(first, second, false);
    }

    public static <K, V> Map<K, V> nullIfElseDefault(Map<K, V> first, Map<K, V> second) {
        return DiffUtils.nullIf(first, second, true);
    }

    public static <K, V> Map<K, V> nullIf(Map<K, V> first, Map<K, V> second, boolean defaultValue) {
        if (Objects.equals(first, second)) {
            return null;
        }
        if (first == null && second != null && second.isEmpty()) {
            return null;
        }
        if (second == null && first != null && first.isEmpty()) {
            return null;
        }
        return defaultValue ? DiffUtils.defaultIfNull(first) : first;
    }

    public static <T extends Mergeable<T>> T nullIf(Mergeable<T> first, T second) {
        return DiffUtils.nullIf(first, second, false);
    }

    public static <T extends Mergeable<T>> T nullIfElseDefault(Mergeable<T> first, T second) {
        return DiffUtils.nullIf(first, second, true);
    }

    public static <T extends Mergeable<T>> T nullIf(Mergeable<T> first, T second, boolean defaultValue) {
        if (first != null) {
            T diff = first.mergeDiff(second);
            if (diff == null || diff.isEmpty()) {
                return null;
            }
            return diff;
        }
        return (T)(defaultValue ? DiffUtils.defaultIfNull(first) : first);
    }
}

