/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffResult;

public class DiffResultHelper {
    public static boolean isEmpty(DiffResult<?> diffs, List<String> ignore) {
        return DiffResultHelper.isEmpty(diffs, (String[])ignore.stream().toArray(String[]::new));
    }

    public static boolean isEmpty(DiffResult<?> diffs, String ... ignore) {
        List filteredDiffs = diffs.getDiffs().stream().filter(diff -> !Arrays.stream(ignore).anyMatch(x -> x.equals(diff.getFieldName()))).collect(Collectors.toList());
        return filteredDiffs.isEmpty();
    }

    public static <T> Diff<T> get(DiffResult<?> diffs, String fieldName) {
        return diffs.getDiffs().stream().filter(diff -> fieldName.equals(diff.getFieldName())).findFirst().orElse(null);
    }

    public static boolean contains(DiffResult<?> diffs, String fieldName) {
        return diffs.getDiffs().stream().anyMatch(diff -> fieldName.equals(diff.getFieldName()));
    }

    public static boolean containsAny(DiffResult<?> diffs, String ... fieldNames) {
        return DiffResultHelper.containsAny(diffs, Arrays.asList(fieldNames));
    }

    public static boolean containsAny(DiffResult<?> diffs, List<String> fieldNames) {
        return diffs.getDiffs().stream().anyMatch(diff -> fieldNames.contains(diff.getFieldName()));
    }
}

