/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.UIUrls;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.model.DruidConfigFile;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.ServiceTier;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.util.MapUtils;
import io.imply.cloud.util.PropertiesHelper;
import io.imply.cloud.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClusterValidationHelper {
    public static List<ImplyConstraintViolation> validateCustomDruidProperties(Map<String, String> properties) {
        ArrayList<ImplyConstraintViolation> results = new ArrayList<ImplyConstraintViolation>();
        if (properties == null) {
            results.add(ImplyConstraintViolation.error("customDruidProperties", "[customDruidProperties] is a required field", new Object[0]));
            return results;
        }
        ClusterValidationHelper.validateCoordinatorProperties(results, ClusterValidationHelper.getDruidPropertiesByService(properties, ServiceType.COORDINATOR, null));
        ClusterValidationHelper.validateOverlordProperties(results, ClusterValidationHelper.getDruidPropertiesByService(properties, ServiceType.OVERLORD, null));
        ClusterValidationHelper.validateBrokerProperties(results, ClusterValidationHelper.getDruidPropertiesByService(properties, ServiceType.BROKER, null));
        ClusterValidationHelper.validateRouterProperties(results, ClusterValidationHelper.getDruidPropertiesByService(properties, ServiceType.ROUTER, null));
        Map<String, String> commonHistoricalProps = ClusterValidationHelper.getDruidPropertiesByService(properties, ServiceType.HISTORICAL, null);
        Map<String, String> tier1HistoricalProps = ClusterValidationHelper.getDruidPropertiesByService(properties, ServiceType.HISTORICAL, ServiceTier.TIER_1);
        ClusterValidationHelper.validateHistoricalProperties(results, MapUtils.putAll(commonHistoricalProps, tier1HistoricalProps), ServiceTier.TIER_1);
        properties.keySet().stream().filter(key -> key.contains(ServiceType.HISTORICAL.getCustomDruidPropertiesKey()) && !key.equals(DruidConfigFile.getCustomDruidPropertiesKey(ServiceType.HISTORICAL, null)) && !key.equals(DruidConfigFile.getCustomDruidPropertiesKey(ServiceType.HISTORICAL, ServiceTier.TIER_1))).forEach(key -> {
            ServiceTier serviceTier = ServiceTier.fromSuffix(key.split(ServiceType.HISTORICAL.getCustomDruidPropertiesKey())[1]);
            Map<String, String> historicalProps = ClusterValidationHelper.getDruidPropertiesByService(properties, ServiceType.HISTORICAL, serviceTier);
            if (!historicalProps.isEmpty()) {
                ClusterValidationHelper.validateHistoricalProperties(results, MapUtils.putAll(commonHistoricalProps, historicalProps), serviceTier);
            }
        });
        Map<String, String> commonMiddleManagerProps = ClusterValidationHelper.getDruidPropertiesByService(properties, ServiceType.MIDDLE_MANAGER, null);
        Map<String, String> tier1MMProps = ClusterValidationHelper.getDruidPropertiesByService(properties, ServiceType.MIDDLE_MANAGER, ServiceTier.TIER_1);
        ClusterValidationHelper.validateMiddleManagerProperties(results, MapUtils.putAll(commonMiddleManagerProps, tier1MMProps), ServiceTier.TIER_1);
        properties.keySet().stream().filter(key -> key.contains(ServiceType.MIDDLE_MANAGER.getCustomDruidPropertiesKey()) && !key.equals(DruidConfigFile.getCustomDruidPropertiesKey(ServiceType.MIDDLE_MANAGER)) && !key.equals(DruidConfigFile.getCustomDruidPropertiesKey(ServiceType.MIDDLE_MANAGER, ServiceTier.TIER_1))).forEach(key -> {
            ServiceTier serviceTier = ServiceTier.fromSuffix(key.split(ServiceType.MIDDLE_MANAGER.getCustomDruidPropertiesKey())[1]);
            Map<String, String> middleManagerProps = ClusterValidationHelper.getDruidPropertiesByService(properties, ServiceType.MIDDLE_MANAGER, serviceTier);
            if (!middleManagerProps.isEmpty()) {
                ClusterValidationHelper.validateMiddleManagerProperties(results, MapUtils.putAll(commonMiddleManagerProps, middleManagerProps), serviceTier);
            }
        });
        return results;
    }

    private static Map<String, String> getDruidPropertiesByService(Map<String, String> properties, ServiceType serviceType, ServiceTier serviceTier) {
        return properties != null ? PropertiesHelper.convertPropertiesFileToMap(properties.get(DruidConfigFile.getCustomDruidPropertiesKey(serviceType, serviceTier))) : ImmutableMap.of();
    }

    private static void validateCoordinatorProperties(List<ImplyConstraintViolation> results, Map<String, String> properties) {
        ClusterValidationHelper.validateServiceProperties(results, ServiceType.COORDINATOR, properties, (List<PropertyValidationEntry>)ImmutableList.of((Object)PropertyValidationEntry.warn("jvm.config.xms", ClusterValidationHelper.jvmXms(DefaultsConfig.COORDINATOR_JVM_HEAP_MB)), (Object)PropertyValidationEntry.warn("jvm.config.xmx", ClusterValidationHelper.jvmXmx(DefaultsConfig.COORDINATOR_JVM_HEAP_MB))));
    }

    private static void validateOverlordProperties(List<ImplyConstraintViolation> results, Map<String, String> properties) {
        ClusterValidationHelper.validateServiceProperties(results, ServiceType.OVERLORD, properties, (List<PropertyValidationEntry>)ImmutableList.of((Object)PropertyValidationEntry.warn("jvm.config.xms", ClusterValidationHelper.jvmXms(DefaultsConfig.OVERLORD_JVM_HEAP_MB)), (Object)PropertyValidationEntry.warn("jvm.config.xmx", ClusterValidationHelper.jvmXmx(DefaultsConfig.OVERLORD_JVM_HEAP_MB))));
    }

    private static void validateBrokerProperties(List<ImplyConstraintViolation> results, Map<String, String> properties) {
        ClusterValidationHelper.validateServiceProperties(results, ServiceType.BROKER, properties, (List<PropertyValidationEntry>)ImmutableList.of((Object)PropertyValidationEntry.error("jvm.config.xms", ClusterValidationHelper.jvmXms(DefaultsConfig.BROKER_JVM_HEAP_MB)), (Object)PropertyValidationEntry.error("jvm.config.xmx", ClusterValidationHelper.jvmXmx(DefaultsConfig.BROKER_JVM_HEAP_MB)), (Object)PropertyValidationEntry.warn("druid.processing.buffer.sizeBytes", DefaultsConfig.PROCESSING_BUFFER_BYTES)));
    }

    private static void validateRouterProperties(List<ImplyConstraintViolation> results, Map<String, String> properties) {
        ClusterValidationHelper.validateServiceProperties(results, ServiceType.ROUTER, properties, (List<PropertyValidationEntry>)ImmutableList.of((Object)PropertyValidationEntry.warn("jvm.config.xms", ClusterValidationHelper.jvmXms(DefaultsConfig.ROUTER_JVM_HEAP_MB)), (Object)PropertyValidationEntry.warn("jvm.config.xmx", ClusterValidationHelper.jvmXmx(DefaultsConfig.ROUTER_JVM_HEAP_MB))));
    }

    private static void validateHistoricalProperties(List<ImplyConstraintViolation> results, Map<String, String> properties, ServiceTier serviceTier) {
        ClusterValidationHelper.validateServiceProperties(results, ServiceType.HISTORICAL, serviceTier, properties, (List<PropertyValidationEntry>)ImmutableList.of((Object)PropertyValidationEntry.error("jvm.config.xms", ClusterValidationHelper.jvmXms(DefaultsConfig.HISTORICAL_JVM_HEAP_MB)), (Object)PropertyValidationEntry.error("jvm.config.xmx", ClusterValidationHelper.jvmXmx(DefaultsConfig.HISTORICAL_JVM_HEAP_MB)), (Object)PropertyValidationEntry.warn("druid.processing.buffer.sizeBytes", DefaultsConfig.PROCESSING_BUFFER_BYTES), (Object)PropertyValidationEntry.warn("druid.processing.numThreads", DefaultsConfig.PROCESSING_THREADS), (Object)PropertyValidationEntry.error("druid.segmentCache.locations", "[{\"path\":\"/mnt/var/druid/segment-cache\",\"maxSize\":10000000000}]"), (Object)PropertyValidationEntry.error("druid.server.maxSize", DefaultsConfig.SEGMENT_CACHE_SIZE_BYTES), (Object)PropertyValidationEntry.warn("druid.cache.sizeInBytes", DefaultsConfig.CACHE_SIZE_BYTES)));
    }

    private static void validateMiddleManagerProperties(List<ImplyConstraintViolation> results, Map<String, String> properties, ServiceTier serviceTier) {
        ClusterValidationHelper.validateServiceProperties(results, ServiceType.MIDDLE_MANAGER, serviceTier, properties, (List<PropertyValidationEntry>)ImmutableList.of((Object)PropertyValidationEntry.error("druid.worker.capacity", DefaultsConfig.WORKER_CAPACITY), (Object)PropertyValidationEntry.warn("druid.indexer.runner.javaOpts", null), (Object)PropertyValidationEntry.warn("druid.processing.buffer.sizeBytes", DefaultsConfig.PROCESSING_BUFFER_BYTES), (Object)PropertyValidationEntry.warn("druid.processing.numThreads", null)));
    }

    private static void validateServiceProperties(List<ImplyConstraintViolation> results, ServiceType serviceType, Map<String, String> propertiesMap, List<PropertyValidationEntry> validatableProperties) {
        ClusterValidationHelper.validateServiceProperties(results, serviceType, null, propertiesMap, validatableProperties);
    }

    private static void validateServiceProperties(List<ImplyConstraintViolation> results, ServiceType serviceType, ServiceTier serviceTier, Map<String, String> propertiesMap, List<PropertyValidationEntry> validatableProperties) {
        String message;
        Preconditions.checkNotNull(results);
        String fieldName = String.format("customDruidProperties.%s", serviceTier == null ? serviceType.getName() : DruidConfigFile.getCustomDruidPropertiesKey(serviceType, serviceTier));
        if (propertiesMap == null) {
            results.add(ImplyConstraintViolation.error(fieldName, "[%s] is a required field", fieldName));
            return;
        }
        HashSet<String> requiredConfigs = new HashSet<String>();
        HashSet<String> recommendedConfigs = new HashSet<String>();
        HashSet<String> defaultValueConfigs = new HashSet<String>();
        for (PropertyValidationEntry entry : validatableProperties) {
            String value = propertiesMap.get(entry.name);
            if (value == null || value.isEmpty()) {
                if (entry.isError()) {
                    requiredConfigs.add(entry.name);
                    continue;
                }
                if (!entry.isWarn()) continue;
                recommendedConfigs.add(entry.name);
                continue;
            }
            if (!value.equals(entry.defaultValue)) continue;
            defaultValueConfigs.add(entry.name);
        }
        if (!requiredConfigs.isEmpty()) {
            message = String.format(requiredConfigs.size() == 1 ? "The property %%s must be set. Refer to the [tuning documentation](%s) for guidelines on suitable values." : "The properties %%s must be set. Refer to the [tuning documentation](%s) for guidelines on suitable values.", UIUrls.getDruidTuningDocUrl(serviceType));
            results.add(ImplyConstraintViolation.error(fieldName, message, StringUtils.joinWithOxfordComma(StringUtils.markdownBold(requiredConfigs))));
        }
        if (!recommendedConfigs.isEmpty()) {
            message = String.format(recommendedConfigs.size() == 1 ? "It is recommended that the property %%s be set. Refer to the [tuning documentation](%s) for guidelines on suitable values." : "It is recommended that the properties %%s be set. Refer to the [tuning documentation](%s) for guidelines on suitable values.", UIUrls.getDruidTuningDocUrl(serviceType));
            results.add(ImplyConstraintViolation.warning(fieldName, message, StringUtils.joinWithOxfordComma(StringUtils.markdownBold(recommendedConfigs))));
        }
        if (!defaultValueConfigs.isEmpty()) {
            message = String.format(defaultValueConfigs.size() == 1 ? "The property %%s is set to the quickstart value which may not be appropriate for general usage. If this is not a quickstart cluster, refer to the [tuning documentation](%s) for guidelines on suitable values." : "The properties %%s are set to the quickstart values which may not be appropriate for general usage. If this is not a quickstart cluster, refer to the [tuning documentation](%s) for guidelines on suitable values.", UIUrls.getDruidTuningDocUrl(serviceType));
            results.add(ImplyConstraintViolation.warning(fieldName, message, StringUtils.joinWithOxfordComma(StringUtils.markdownBold(defaultValueConfigs))));
        }
    }

    private static String jvmXms(int sizeMb) {
        return String.format("-Xms%dm", sizeMb);
    }

    private static String jvmXmx(int sizeMb) {
        return String.format("-Xmx%dm", sizeMb);
    }

    private static class PropertyValidationEntry {
        private final String name;
        private final ImplyConstraintViolation.Severity severity;
        private final String defaultValue;

        private PropertyValidationEntry(String name, ImplyConstraintViolation.Severity severity, Object defaultValue) {
            this.name = name;
            this.severity = severity;
            this.defaultValue = defaultValue != null ? defaultValue.toString() : null;
        }

        private boolean isWarn() {
            return ImplyConstraintViolation.Severity.WARNING.equals((Object)this.severity);
        }

        private boolean isError() {
            return ImplyConstraintViolation.Severity.ERROR.equals((Object)this.severity);
        }

        private static PropertyValidationEntry warn(String name, Object defaultValue) {
            return new PropertyValidationEntry(name, ImplyConstraintViolation.Severity.WARNING, defaultValue);
        }

        private static PropertyValidationEntry error(String name, Object defaultValue) {
            return new PropertyValidationEntry(name, ImplyConstraintViolation.Severity.ERROR, defaultValue);
        }
    }
}

