/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.persistence.ClusterNodesDataManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClusterNodesHelper {
    private ClusterNodesDataManager clusterNodesDataManager;

    @Inject
    public ClusterNodesHelper(ClusterNodesDataManager clusterNodesDataManager) {
        this.clusterNodesDataManager = clusterNodesDataManager;
    }

    public List<String> getSortedMasterHosts(String clusterId) {
        return ClusterNodesHelper.getSortedMasterHosts(this.getNodeConfigurations(clusterId));
    }

    public List<String> getSortedQueryHosts(String clusterId) {
        return ClusterNodesHelper.getSortedQueryHosts(this.getNodeConfigurations(clusterId));
    }

    public List<String> getSortedDataHosts(String clusterId) {
        return ClusterNodesHelper.getSortedDataHosts(this.getNodeConfigurations(clusterId));
    }

    public List<String> getSortedHosts(String clusterId) {
        return ClusterNodesHelper.getSortedHosts(this.getNodeConfigurations(clusterId), null);
    }

    public Map<ImplyNodeType, Map<String, NodeConfiguration>> getNodesByImplyNodeType(String clusterId) {
        return ClusterNodesHelper.getNodesByImplyNodeType(this.getNodeConfigurations(clusterId));
    }

    public Boolean isHostOnline(String clusterId, String host) {
        return this.getNodeConfigurations(clusterId).containsKey(host);
    }

    public List<String> filterOnlineHosts(String clusterId, List<String> hosts) {
        Map<String, NodeConfiguration> nodes = this.getNodeConfigurations(clusterId);
        return hosts.stream().filter(h -> nodes.containsKey(h)).collect(Collectors.toList());
    }

    public static List<String> getSortedMasterHosts(Map<String, NodeConfiguration> nodes) {
        return ClusterNodesHelper.getSortedHosts(nodes, (Collection<ImplyNodeType>)ImmutableList.of((Object)ImplyNodeType.MASTER));
    }

    public static List<String> getSortedQueryHosts(Map<String, NodeConfiguration> nodes) {
        return ClusterNodesHelper.getSortedHosts(nodes, (Collection<ImplyNodeType>)ImmutableList.of((Object)ImplyNodeType.QUERY));
    }

    public static List<String> getSortedDataHosts(Map<String, NodeConfiguration> nodes) {
        return ClusterNodesHelper.getSortedHosts(nodes, ClusterNodesHelper.getAllDataTiers(nodes));
    }

    public static List<ImplyNodeType> getAllDataTiers(Map<String, NodeConfiguration> nodes) {
        return nodes.values().stream().flatMap(nc -> nc.getNodeTypes().stream()).filter(nodeType -> ImplyNodeType.ImplyNodeServiceType.DATA.equals((Object)nodeType.getNodeServiceType())).distinct().collect(Collectors.toList());
    }

    public static List<String> getSortedHosts(Map<String, NodeConfiguration> nodes) {
        return ClusterNodesHelper.getSortedHosts(nodes, null);
    }

    public static List<String> getSortedHosts(Map<String, NodeConfiguration> nodes, Collection<ImplyNodeType> nodeTypes) {
        ArrayList<String> hosts = new ArrayList<String>();
        if (nodes == null) {
            return hosts;
        }
        if (nodeTypes == null) {
            hosts.addAll(nodes.keySet());
        } else {
            block0: for (Map.Entry<String, NodeConfiguration> node : nodes.entrySet()) {
                for (ImplyNodeType nodeType : nodeTypes) {
                    if (node.getValue() == null || node.getValue().getNodeTypes() == null || !node.getValue().getNodeTypes().contains(nodeType)) continue;
                    hosts.add(node.getKey());
                    continue block0;
                }
            }
        }
        return hosts.stream().distinct().sorted().collect(Collectors.toList());
    }

    public static Map<ImplyNodeType, Map<String, NodeConfiguration>> getNodesByImplyNodeType(Map<String, NodeConfiguration> nodes) {
        HashMap<ImplyNodeType, Map<String, NodeConfiguration>> implyNodeTypeMap = new HashMap<ImplyNodeType, Map<String, NodeConfiguration>>();
        if (nodes == null) {
            return implyNodeTypeMap;
        }
        for (Map.Entry<String, NodeConfiguration> item : nodes.entrySet()) {
            if (item.getValue() == null || item.getValue().getNodeTypes() == null) continue;
            for (ImplyNodeType nodeType : item.getValue().getNodeTypes()) {
                implyNodeTypeMap.computeIfAbsent(nodeType, x -> new HashMap());
                ((Map)implyNodeTypeMap.get(nodeType)).put(item.getKey(), item.getValue());
            }
        }
        return implyNodeTypeMap;
    }

    private Map<String, NodeConfiguration> getNodeConfigurations(String clusterId) {
        ClusterNodes clusterNodes = this.clusterNodesDataManager.getOrNull(clusterId);
        return clusterNodes == null || clusterNodes.getNodes() == null ? ImmutableMap.of() : clusterNodes.getNodes();
    }
}

