/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.security;

import io.imply.cloud.security.ImplyTokenValidator;
import io.imply.cloud.util.StringUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SymmetricTokenValidator
implements ImplyTokenValidator {
    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private final Mac hmac;

    public SymmetricTokenValidator(String secret) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(StringUtils.toUtf8(secret), "HmacSHA256");
        this.hmac = Mac.getInstance("HmacSHA256");
        this.hmac.init(secretKeySpec);
    }

    @Override
    public boolean validate(String token, String receivedHmac) {
        String localHmac = this.getSignature(token);
        return localHmac.equals(receivedHmac);
    }

    @Override
    public String getSignature(String msg) {
        return ENCODER.encodeToString(this.hmac.doFinal(StringUtils.toUtf8(msg)));
    }
}

