/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.guice.JsonConfigProvider;
import io.imply.cloud.guice.LifecycleModule;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.security.CertificateManager;
import io.imply.cloud.security.DruidAuthManager;
import io.imply.cloud.security.SSLCertificateManager;

public class SecurityModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "security", SecurityConfig.class);
        binder.bind(CertificateManager.class).to(SSLCertificateManager.class).in(LazySingleton.class);
        binder.bind(DruidAuthManager.class).in(LazySingleton.class);
        LifecycleModule.register(binder, CertificateManager.class);
    }
}

