/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.security;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.security.CertificateManager;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.SecurityUtil;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLCertificateManager
implements CertificateManager {
    private static final Logger log = new Logger(SSLCertificateManager.class);
    private final SecurityConfig securityConfig;
    private final KeyStore keyStore;
    private final SslContextFactory sslContextFactory;
    private final JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();

    @Inject
    public SSLCertificateManager(SecurityConfig securityConfig) throws Exception {
        this.securityConfig = securityConfig;
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.keyStore.load(null);
        this.loadAllCertificates();
        this.sslContextFactory = new SslContextFactory();
        this.sslContextFactory.setSslContext(this.getSslContext());
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    private void loadAllCertificates() throws Exception {
        try {
            if (!this.keyStore.containsAlias(this.securityConfig.getSigningKeyStoreAlias())) {
                X509Certificate cert = this.certificateConverter.getCertificate(new X509CertificateHolder(this.securityConfig.getRootCertificate()));
                this.keyStore.setCertificateEntry(this.securityConfig.getSigningKeyStoreAlias(), cert);
                log.info("Added root certificate for Imply Cloud");
            }
            if (this.securityConfig.getAlternateRootCertificates() != null) {
                for (int i = 0; i < this.securityConfig.getAlternateRootCertificates().size(); ++i) {
                    X509Certificate cert = this.certificateConverter.getCertificate(new X509CertificateHolder(this.securityConfig.getAlternateRootCertificates().get(i)));
                    String certAlias = String.format("alt%d", i);
                    this.keyStore.setCertificateEntry(certAlias, cert);
                    log.info("Added alternate root certificate [%s] for Imply Cloud", certAlias);
                }
            }
        }
        catch (Exception e) {
            log.error(e, "Exception adding root certificate to keystore");
        }
    }

    private SSLContext getSslContext() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(this.keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, CompositeTrustManager.getTrustManagers(this.keyStore), SecurityUtil.SECURE_RANDOM);
            return sslContext;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static class CompositeTrustManager
    implements X509TrustManager {
        private final List<X509TrustManager> trustManagers;

        private CompositeTrustManager(KeyStore keyStore) throws Exception {
            this.trustManagers = ImmutableList.of((Object)CompositeTrustManager.getDefaultTrustManager(), (Object)CompositeTrustManager.getTrustManager(keyStore));
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509TrustManager trustManager : this.trustManagers) {
                try {
                    trustManager.checkClientTrusted(chain, authType);
                    return;
                }
                catch (CertificateException certificateException) {
                }
            }
            throw new CertificateException("No trust managers trust this chain");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509TrustManager trustManager : this.trustManagers) {
                try {
                    trustManager.checkServerTrusted(chain, authType);
                    return;
                }
                catch (CertificateException certificateException) {
                }
            }
            throw new CertificateException("No trust managers trust this chain");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return (X509Certificate[])this.trustManagers.stream().flatMap(x -> Arrays.stream(x.getAcceptedIssuers())).toArray(X509Certificate[]::new);
        }

        public static TrustManager[] getTrustManagers(KeyStore keyStore) throws Exception {
            return new TrustManager[]{new CompositeTrustManager(keyStore)};
        }

        private static X509TrustManager getDefaultTrustManager() throws Exception {
            return CompositeTrustManager.getTrustManager(null);
        }

        private static X509TrustManager getTrustManager(KeyStore keyStore) throws Exception {
            return CompositeTrustManager.getTrustManager(TrustManagerFactory.getDefaultAlgorithm(), keyStore);
        }

        private static X509TrustManager getTrustManager(String algorithm, KeyStore keyStore) throws Exception {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
            factory.init(keyStore);
            return Arrays.stream(factory.getTrustManagers()).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst().get();
        }
    }
}

