/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.security;

import com.google.common.annotations.VisibleForTesting;
import io.imply.cloud.security.Authentication;
import io.imply.cloud.security.ImplyTokenManager;
import org.eclipse.jetty.client.api.Request;

public class ImplyAuthentication
implements Authentication {
    private final ImplyTokenManager tokenManager;

    public ImplyAuthentication(String hmac) {
        this.tokenManager = new ImplyTokenManager(hmac);
    }

    @VisibleForTesting
    protected ImplyAuthentication(ImplyTokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    @Override
    public ImplyAuthenticationResult authenticate() {
        ImplyTokenManager.ImplyTokenResult tokenResult = this.tokenManager.getToken();
        return new ImplyAuthenticationResult(tokenResult.getEncodedToken(), tokenResult.getTokenSignature());
    }

    @Override
    public void logout() {
    }

    public static class ImplyAuthenticationResult
    implements Authentication.Result {
        private final String token;
        private final String hmac;

        public ImplyAuthenticationResult(String token, String hmac) {
            this.token = token;
            this.hmac = hmac;
        }

        @Override
        public void apply(Request request) {
            if (!request.getHeaders().contains("Imply-Token", this.token)) {
                request.header("Imply-Token", this.token);
            }
            if (!request.getHeaders().contains("Imply-HMAC", this.hmac)) {
                request.header("Imply-HMAC", this.hmac);
            }
        }
    }
}

