/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.security;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.Inject;
import io.imply.cloud.configurator.authenticator.ClusterAuthConfigurator;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.security.Authentication;
import io.imply.cloud.util.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class DruidAuthManager {
    @Generated
    private static final Logger log = Logger.from(DruidAuthManager.class);
    private final ClusterAuthConfigurator clusterAuthConfigurator;
    protected final Map<String, Authentication> authCache = new ConcurrentHashMap<String, Authentication>();

    @Inject
    public DruidAuthManager(ClusterAuthConfigurator clusterAuthConfigurator) {
        this.clusterAuthConfigurator = clusterAuthConfigurator;
    }

    public Authentication.Result getAuthentication(Cluster cluster) throws JsonProcessingException {
        if (cluster == null) {
            return null;
        }
        String clusterId = cluster.getClusterId();
        Authentication auth = this.authCache.get(clusterId);
        if (auth == null) {
            auth = this.clusterAuthConfigurator.getAuthentication(cluster);
        }
        if (auth == null) {
            return null;
        }
        this.authCache.putIfAbsent(clusterId, auth);
        return auth.authenticate();
    }

    public void clear(String clusterId) {
        Authentication auth = this.authCache.remove(clusterId);
        if (auth != null) {
            try {
                auth.logout();
            }
            catch (Exception e) {
                log.warn(e, "Failed to logout auth session for cluster [%s]", clusterId);
            }
        }
    }
}

