/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.cache.Cache;
import io.imply.cloud.cache.CacheKey;
import io.imply.cloud.model.User;
import io.imply.cloud.persistence.UserDataManager;
import io.imply.cloud.util.Logger;
import java.util.List;

public class CachedUserDataManager
implements UserDataManager {
    private static final Logger log = new Logger(CachedUserDataManager.class);
    private final UserDataManager userDataManager;
    private final Cache cache;
    private final ObjectMapper objectMapper;

    public CachedUserDataManager(UserDataManager userDataManager, Cache cache, ObjectMapper objectMapper) {
        this.userDataManager = userDataManager;
        this.cache = cache;
        this.objectMapper = objectMapper;
    }

    @Override
    public User create(User user, String createdBy) {
        User retVal = this.userDataManager.create(user, createdBy);
        this.cache.put(CacheKey.user(retVal.getUserId()), this.serialize(retVal));
        return retVal;
    }

    @Override
    public User update(User user, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) {
        User retVal = this.userDataManager.update(user, updatedBy, autoIncrementVersion, mergeWithPrevious);
        this.cache.put(CacheKey.user(retVal.getUserId()), this.serialize(retVal));
        return retVal;
    }

    @Override
    public User get(String userId) {
        User retVal = this.deserialize(this.cache.get(CacheKey.user(userId)));
        if (retVal == null && (retVal = this.userDataManager.get(userId)) != null) {
            this.cache.put(CacheKey.user(retVal.getUserId()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public User getOrNull(String userId) {
        User retVal = this.deserialize(this.cache.get(CacheKey.user(userId)));
        if (retVal == null && (retVal = this.userDataManager.getOrNull(userId)) != null) {
            this.cache.put(CacheKey.user(retVal.getUserId()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public List<User> getAllWithAccountId(String accountId) {
        return this.userDataManager.getAllWithAccountId(accountId);
    }

    @Override
    public String delete(String userId, String deletedBy) {
        String retVal = this.userDataManager.delete(userId, deletedBy);
        this.cache.invalidate(CacheKey.user(userId));
        return retVal;
    }

    private byte[] serialize(User user) {
        if (user == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes((Object)user);
        }
        catch (Exception e) {
            log.info(e, "Cache serialization failed: %s", user);
            return null;
        }
    }

    private User deserialize(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (User)this.objectMapper.readValue(data, User.class);
        }
        catch (Exception e) {
            log.info(e, "Cache deserialization failed");
            return null;
        }
    }
}

