/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.cache.Cache;
import io.imply.cloud.cache.CacheKey;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceHealth;
import io.imply.cloud.persistence.InstanceHealthDataManager;
import io.imply.cloud.util.Logger;
import java.util.List;

public class CachedInstanceHealthDataManager
implements InstanceHealthDataManager {
    private static final Logger log = new Logger(CachedInstanceHealthDataManager.class);
    private final InstanceHealthDataManager instanceHealthDataManager;
    private final Cache cache;
    private final ObjectMapper objectMapper;

    public CachedInstanceHealthDataManager(InstanceHealthDataManager instanceHealthDataManager, Cache cache, ObjectMapper objectMapper) {
        this.instanceHealthDataManager = instanceHealthDataManager;
        this.cache = cache;
        this.objectMapper = objectMapper;
    }

    @Override
    public InstanceHealth insert(InstanceHealth instanceHealth) {
        InstanceHealth retVal = this.instanceHealthDataManager.insert(instanceHealth);
        this.cache.put(CacheKey.instanceHealth(retVal.getKey()), this.serialize(retVal));
        return retVal;
    }

    @Override
    public InstanceHealth getOrNull(String clusterId, String instanceId, ImplyNodeType implyNodeType) {
        String key = InstanceHealth.createKey(clusterId, instanceId, implyNodeType);
        InstanceHealth retVal = this.deserialize(this.cache.get(CacheKey.instanceHealth(key)));
        if (retVal == null && (retVal = this.instanceHealthDataManager.getOrNull(clusterId, instanceId, implyNodeType)) != null) {
            this.cache.put(CacheKey.instanceHealth(retVal.getKey()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public List<InstanceHealth> getAllFailedInstances() {
        return this.instanceHealthDataManager.getAllFailedInstances();
    }

    @Override
    public List<InstanceHealth> getAllForCluster(String clusterId) {
        return this.instanceHealthDataManager.getAllForCluster(clusterId);
    }

    @Override
    public String delete(String key) {
        String retVal = this.instanceHealthDataManager.delete(key);
        this.cache.invalidate(CacheKey.instanceHealth(key));
        return retVal;
    }

    private byte[] serialize(InstanceHealth instanceHealth) {
        if (instanceHealth == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes((Object)instanceHealth);
        }
        catch (Exception e) {
            log.info(e, "Cache serialization failed: %s", instanceHealth);
            return null;
        }
    }

    private InstanceHealth deserialize(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (InstanceHealth)this.objectMapper.readValue(data, InstanceHealth.class);
        }
        catch (Exception e) {
            log.info(e, "Cache deserialization failed");
            return null;
        }
    }
}

