/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.cache.Cache;
import io.imply.cloud.cache.CacheKey;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.function.Consumer;
import org.skife.jdbi.v2.Handle;

public class CachedEntityStateDataManager
implements EntityStateDataManager {
    private static final Logger log = new Logger(CachedEntityStateDataManager.class);
    private final EntityStateDataManager entityStateDataManager;
    private final Cache cache;
    private final ObjectMapper objectMapper;

    public CachedEntityStateDataManager(EntityStateDataManager entityStateDataManager, Cache cache, ObjectMapper objectMapper) {
        this.entityStateDataManager = entityStateDataManager;
        this.cache = cache;
        this.objectMapper = objectMapper;
    }

    @Override
    public Info insert(String entityKey, String entityId, EntityType entityType, Info entityState, Consumer<Handle> inTxn) {
        Info retVal = this.entityStateDataManager.insert(entityKey, entityId, entityType, entityState, inTxn);
        this.cache.put(CacheKey.entityState(retVal.getEntityId()), this.serialize(retVal));
        return retVal;
    }

    @Override
    public Info insertWithHandle(Handle handle, String entityKey, String entityId, EntityType entityType, Info entityState) {
        Info retVal = this.entityStateDataManager.insertWithHandle(handle, entityKey, entityId, entityType, entityState);
        this.cache.put(CacheKey.entityState(retVal.getEntityId()), this.serialize(retVal));
        return retVal;
    }

    @Override
    public Info get(String entityId) {
        Info retVal = this.deserialize(this.cache.get(CacheKey.entityState(entityId)));
        if (retVal == null && (retVal = this.entityStateDataManager.get(entityId)) != null) {
            this.cache.put(CacheKey.entityState(entityId), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public Info getOrNull(String entityId) {
        Info retVal = this.deserialize(this.cache.get(CacheKey.entityState(entityId)));
        if (retVal == null && (retVal = this.entityStateDataManager.getOrNull(entityId)) != null) {
            this.cache.put(CacheKey.entityState(entityId), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public List<Info> getAllWithType(EntityType entityType) {
        return this.entityStateDataManager.getAllWithType(entityType);
    }

    @Override
    public List<Info> getAllInTransitionStates() {
        return this.entityStateDataManager.getAllInTransitionStates();
    }

    @Override
    public String delete(String entityId) {
        String retVal = this.entityStateDataManager.delete(entityId);
        this.cache.invalidate(CacheKey.entityState(entityId));
        return retVal;
    }

    private byte[] serialize(Info info) {
        if (info == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes((Object)info);
        }
        catch (Exception e) {
            log.info(e, "Cache serialization failed: %s", info);
            return null;
        }
    }

    private Info deserialize(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (Info)this.objectMapper.readValue(data, Info.class);
        }
        catch (Exception e) {
            log.info(e, "Cache deserialization failed");
            return null;
        }
    }
}

