/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.cache.Cache;
import io.imply.cloud.cache.CacheKey;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.Info;
import io.imply.cloud.persistence.ClusterNodesDataManager;
import io.imply.cloud.util.Logger;
import java.util.ArrayList;
import java.util.List;
import org.skife.jdbi.v2.Handle;

public class CachedClusterNodesDataManager
implements ClusterNodesDataManager {
    private static final Logger log = new Logger(CachedClusterNodesDataManager.class);
    private final ClusterNodesDataManager clusterNodesDataManager;
    private final Cache cache;
    private final ObjectMapper objectMapper;

    public CachedClusterNodesDataManager(ClusterNodesDataManager clusterNodesDataManager, Cache cache, ObjectMapper objectMapper) {
        this.clusterNodesDataManager = clusterNodesDataManager;
        this.cache = cache;
        this.objectMapper = objectMapper;
    }

    @Override
    public ClusterNodes insert(ClusterNodes clusterNodes, String insertedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) {
        ClusterNodes retVal = this.clusterNodesDataManager.insert(clusterNodes, insertedBy, autoIncrementVersion, mergeWithPrevious);
        this.cache.invalidate(CacheKey.clusterNodesList());
        this.cache.put(CacheKey.clusterNodes(retVal.getClusterId()), this.serialize(retVal));
        return retVal;
    }

    @Override
    public ClusterNodes insertWithInfo(ClusterNodes clusterNodes, Info info, String insertedBy, boolean autoIncrementVersion, boolean updateDeployedClusterNodesVersion, boolean mergeWithPrevious) {
        ClusterNodes retVal = this.clusterNodesDataManager.insertWithInfo(clusterNodes, info, insertedBy, autoIncrementVersion, updateDeployedClusterNodesVersion, mergeWithPrevious);
        this.cache.invalidate(CacheKey.clusterNodesList());
        this.cache.put(CacheKey.clusterNodes(retVal.getClusterId()), this.serialize(retVal));
        return retVal;
    }

    @Override
    public ClusterNodes get(String clusterId) {
        ClusterNodes retVal = this.deserialize(this.cache.get(CacheKey.clusterNodes(clusterId)));
        if (retVal == null && (retVal = this.clusterNodesDataManager.get(clusterId)) != null) {
            this.cache.put(CacheKey.clusterNodes(retVal.getClusterId()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public ClusterNodes getOrNull(String clusterId) {
        ClusterNodes retVal = this.deserialize(this.cache.get(CacheKey.clusterNodes(clusterId)));
        if (retVal == null && (retVal = this.clusterNodesDataManager.getOrNull(clusterId)) != null) {
            this.cache.put(CacheKey.clusterNodes(retVal.getClusterId()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public ClusterNodes getVersionOrNull(String clusterId, int version) {
        return this.clusterNodesDataManager.getVersionOrNull(clusterId, version);
    }

    @Override
    public List<ClusterNodes> getAll() {
        List<ClusterNodes> retVal = this.getCachedClusterNodesList();
        if (retVal == null && (retVal = this.clusterNodesDataManager.getAll()) != null) {
            this.cacheClusterNodesList(retVal);
        }
        return retVal;
    }

    @Override
    public String deleteWithHandle(Handle handle, String clusterId, String deletedBy) {
        String retVal = this.clusterNodesDataManager.deleteWithHandle(handle, clusterId, deletedBy);
        this.cache.invalidate(CacheKey.clusterNodesList());
        this.cache.invalidate(CacheKey.clusterNodes(clusterId));
        return retVal;
    }

    private byte[] serialize(ClusterNodes clusterNodes) {
        if (clusterNodes == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes((Object)clusterNodes);
        }
        catch (Exception e) {
            log.info(e, "Cache serialization failed: %s", clusterNodes);
            return null;
        }
    }

    private ClusterNodes deserialize(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (ClusterNodes)this.objectMapper.readValue(data, ClusterNodes.class);
        }
        catch (Exception e) {
            log.info(e, "Cache deserialization failed");
            return null;
        }
    }

    private void cacheClusterNodesList(List<ClusterNodes> clusterNodesList) {
        if (clusterNodesList == null) {
            return;
        }
        ArrayList<String> clusterIds = new ArrayList<String>();
        for (ClusterNodes clusterNodes : clusterNodesList) {
            try {
                this.cache.put(CacheKey.clusterNodes(clusterNodes.getClusterId()), this.objectMapper.writeValueAsBytes((Object)clusterNodes));
                clusterIds.add(clusterNodes.getClusterId());
            }
            catch (Exception e) {
                log.info(e, "Cache serialization failed for clusterId [%s]", clusterNodes.getClusterId());
            }
        }
        try {
            this.cache.put(CacheKey.clusterNodesList(), this.objectMapper.writeValueAsBytes(clusterIds));
        }
        catch (Exception e) {
            log.info(e, "Cache serialization failed: %s", clusterIds);
        }
    }

    private List<ClusterNodes> getCachedClusterNodesList() {
        byte[] bClusterNodesList = this.cache.get(CacheKey.clusterNodesList());
        if (bClusterNodesList == null) {
            return null;
        }
        try {
            List clusterIds = (List)this.objectMapper.readValue(bClusterNodesList, (TypeReference)new TypeReference<List<String>>(){});
            ArrayList<ClusterNodes> clusterNodesList = new ArrayList<ClusterNodes>();
            for (String clusterId : clusterIds) {
                byte[] bClusterNodes = this.cache.get(CacheKey.clusterNodes(clusterId));
                if (bClusterNodes == null) {
                    return null;
                }
                clusterNodesList.add((ClusterNodes)this.objectMapper.readValue(bClusterNodes, ClusterNodes.class));
            }
            return clusterNodesList;
        }
        catch (Exception e) {
            log.info(e, "Cache deserialization failed");
            return null;
        }
    }
}

