/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.exception.AlreadyExistsException;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.model.User;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.SQLAppendingDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.StorageTablesConfig;
import io.imply.cloud.persistence.UserDataManager;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.NRE;
import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.NoResultsException;

@ManageLifecycle
public class SQLUserDataManager
extends SQLAppendingDataManager<User>
implements UserDataManager {
    private final String userTableName;
    private final JavaType javaType;
    private final ApplicationConfig applicationConfig;

    @Inject
    public SQLUserDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector, Supplier<StorageTablesConfig> dbTables, ApplicationConfig applicationConfig) {
        super(jsonMapper, connector);
        this.userTableName = ((StorageTablesConfig)dbTables.get()).getUsersTable();
        this.javaType = jsonMapper.getTypeFactory().constructType(User.class);
        this.applicationConfig = applicationConfig;
    }

    @Override
    @LifecycleStart
    public void start() {
        if (!this.applicationConfig.isSaaS() && !this.applicationConfig.isIOW()) {
            this.createTable();
        }
    }

    @Override
    public User create(User user, String createdBy) {
        return (User)this.dbi.inTransaction((handle, transactionStatus) -> {
            String userId = user.getUserId();
            if (this.existsWithHandle(handle, userId, DeletedVisibility.HIDE)) {
                throw new AlreadyExistsException(this.getJavaType().getRawClass(), userId);
            }
            User userToInsert = userId == null ? user.withUserId(this.generateUUIDWithHandle(handle)) : user;
            try {
                User possiblePreviousUser = (User)this.getWithHandle(handle, userToInsert.getUserId(), DeletedVisibility.SHOW_ALL);
                userToInsert = userToInsert.withVersion(possiblePreviousUser.getVersion() + 1);
            }
            catch (NoResultsException e) {
                userToInsert = userToInsert.withVersion(0);
            }
            return this.insertWithHandle(handle, userToInsert.withCreated(DateTime.now()).withLastModified(DateTime.now()), createdBy);
        });
    }

    @Override
    public User update(User user, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) {
        return (User)this.dbi.inTransaction((handle, transactionStatus) -> {
            String userId = user.getUserId();
            if (!this.existsWithHandle(handle, userId, DeletedVisibility.HIDE)) {
                throw new NRE(this.getJavaType().getRawClass(), userId);
            }
            User previousUser = (User)this.getWithHandle(handle, userId, DeletedVisibility.HIDE);
            User userToUpdate = mergeWithPrevious ? previousUser.merge(user) : user;
            int expectedVersion = previousUser.getVersion() + 1;
            if (autoIncrementVersion) {
                userToUpdate = userToUpdate.withVersion(expectedVersion);
            }
            if (userToUpdate.getVersion() != expectedVersion) {
                throw new IAE("Update failed for user [%s]: received version [%d], expecting version [%d]", userId, userToUpdate.getVersion(), expectedVersion);
            }
            return this.insertWithHandle(handle, userToUpdate.withLastModified(DateTime.now()), updatedBy);
        });
    }

    @Override
    public List<User> getAllWithAccountId(String accountId) {
        return this.getAllWithAccountId(accountId, DeletedVisibility.HIDE);
    }

    private List<User> getAllWithAccountId(String accountId, DeletedVisibility deletedVisibility) {
        return this.getAll(deletedVisibility).stream().filter(x -> x.getAccountIds().contains(accountId)).collect(Collectors.toList());
    }

    @Override
    protected String getTableName() {
        return this.userTableName;
    }

    @Override
    protected String getMainKeyColumnName() {
        return "user_id";
    }

    @Override
    protected JavaType getJavaType() {
        return this.javaType;
    }

    @Override
    protected void createTable() {
        this.connector.createTable(this.getTableName(), (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (%n  %2$s VARCHAR(100) NOT NULL,%n  version INT NOT NULL,%n  inserted_by VARCHAR(100),%n  updated_by VARCHAR(100),%n  created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  last_modified TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  payload %3$s NOT NULL,%n  used BOOLEAN NOT NULL,%n  user_id_version_sha1 VARCHAR(100) NOT NULL,%n  PRIMARY KEY (user_id_version_sha1)%n);", this.getTableName(), this.getMainKeyColumnName(), this.connector.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_%2$s ON %1$s(%2$s)", this.getTableName(), this.getMainKeyColumnName())));
        this.connector.createIndex(this.getTableName(), String.format("idx_%1$s_%2$s_used_version", this.getTableName(), this.getMainKeyColumnName()), (List<String>)ImmutableList.of((Object)this.getMainKeyColumnName(), (Object)"used", (Object)"version"));
    }

    private User insertWithHandle(Handle handle, User user, String insertedBy) throws JsonProcessingException {
        String userId = user.getUserId();
        String userIdVersionSha1 = DigestUtils.sha1Hex((String)(userId + user.getVersion()));
        ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %1$s (%2$s, version, inserted_by, created, last_modified, payload, used, user_id_version_sha1) VALUES (:userId, :version, :insertedBy, :created, :lastModified, :payload, :used, :userIdVersionSha1)", this.getTableName(), this.getMainKeyColumnName())).bind("userId", userId)).bind("version", user.getVersion())).bind("insertedBy", insertedBy)).bind("created", user.getCreated() != null ? new Timestamp(user.getCreated().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("lastModified", user.getLastModified() != null ? new Timestamp(user.getLastModified().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("payload", this.jsonMapper.writeValueAsBytes((Object)user))).bind("used", true)).bind("userIdVersionSha1", userIdVersionSha1)).execute();
        return user;
    }
}

