/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jdbi.InstrumentedTimingCollector;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import io.imply.cloud.persistence.StorageConnectorConfig;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.RetryUtils;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.logging.SLF4JLog;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.skife.jdbi.v2.tweak.transactions.SerializableTransactionRunner;
import org.slf4j.LoggerFactory;

public abstract class SQLStorageConnector {
    private static final Logger log = new Logger(SQLStorageConnector.class);
    private static final String PAYLOAD_TYPE = "BLOB";
    public static final int DEFAULT_MAX_TRIES = 10;
    private final Supplier<StorageConnectorConfig> config;
    private final Predicate<Throwable> shouldRetry;
    private final MetricRegistry metricRegistry;

    public SQLStorageConnector(Supplier<StorageConnectorConfig> config, MetricRegistry metricRegistry) {
        this.config = config;
        this.shouldRetry = e -> this.isTransientException((Throwable)e);
        this.metricRegistry = metricRegistry;
    }

    public String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    protected abstract String getSerialType();

    protected abstract int getStreamingFetchSize();

    public abstract String getQuoteString();

    public String getValidationQuery() {
        return "SELECT 1";
    }

    public abstract boolean tableExists(Handle var1, String var2);

    public <T> T retryWithHandle(HandleCallback<T> callback) {
        return this.retryWithHandle(callback, this.shouldRetry);
    }

    public final boolean isTransientException(Throwable e) {
        return e != null && (e instanceof SQLTransientException || e instanceof SQLRecoverableException || e instanceof UnableToObtainConnectionException || e instanceof UnableToExecuteStatementException || this.connectorIsTransientException(e) || e instanceof SQLException && this.isTransientException(e.getCause()) || e instanceof DBIException && this.isTransientException(e.getCause()));
    }

    protected boolean connectorIsTransientException(Throwable e) {
        return false;
    }

    public void createTable(String tableName, Iterable<String> sql) {
        try {
            this.retryWithHandle(handle -> {
                if (!this.tableExists(handle, tableName)) {
                    log.info("Creating table[%s]", tableName);
                    Batch batch = handle.createBatch();
                    for (String s : sql) {
                        batch.add(s);
                    }
                    batch.execute();
                } else {
                    log.debug("Table[%s] already exists", tableName);
                }
                return null;
            });
        }
        catch (Exception e) {
            log.warn(e, "Exception creating table");
        }
    }

    public void createIndex(String tableName, String indexName, List<String> indexCols) {
        try {
            this.retryWithHandle(handle -> {
                if (!this.indexExists(tableName, indexName)) {
                    String indexSQL = io.imply.cloud.util.StringUtils.safeFormat("CREATE INDEX %1$s ON %2$s(%3$s)", indexName, tableName, Joiner.on((String)",").join((Iterable)indexCols));
                    log.info("Creating Index on Table [%s], sql: [%s] ", tableName, indexSQL);
                    handle.execute(indexSQL, new Object[0]);
                } else {
                    log.info("Index [%s] on Table [%s] already exists", indexName, tableName);
                }
                return null;
            });
        }
        catch (Exception e) {
            log.error(e, io.imply.cloud.util.StringUtils.safeFormat("Exception while creating index on table [%s]", tableName));
        }
    }

    protected boolean indexExists(String tableName, String name) {
        try {
            return (Boolean)this.retryWithHandle(handle -> {
                DatabaseMetaData databaseMetaData = handle.getConnection().getMetaData();
                ResultSet resultSet = databaseMetaData.getIndexInfo(null, null, tableName, false, false);
                while (resultSet.next()) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)resultSet.getString("INDEX_NAME"))) continue;
                    return true;
                }
                return false;
            });
        }
        catch (Exception e) {
            log.error(e, "Exception while listing the index on table %s ", tableName);
            return false;
        }
    }

    public abstract DBI getDBI();

    public StorageConnectorConfig getConfig() {
        return (StorageConnectorConfig)this.config.get();
    }

    protected BasicDataSource getDatasource() {
        StorageConnectorConfig connectorConfig = this.getConfig();
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(connectorConfig.getUser());
        dataSource.setPassword(connectorConfig.getPassword());
        String uri = connectorConfig.getConnectURI();
        dataSource.setUrl(uri);
        dataSource.setValidationQuery(this.getValidationQuery());
        dataSource.setTestOnBorrow(true);
        return dataSource;
    }

    protected DBI createDBI(DataSource datasource) {
        DBI dbi = new DBI(datasource);
        dbi.setSQLLog((SQLLog)new SLF4JLog(LoggerFactory.getLogger((String)"org.skife.jdbi.v2"), SLF4JLog.Level.DEBUG));
        dbi.setTimingCollector((TimingCollector)new InstrumentedTimingCollector(this.metricRegistry));
        dbi.setTransactionHandler((TransactionHandler)new SerializableTransactionRunner());
        return dbi;
    }

    private <T> T retryWithHandle(HandleCallback<T> callback, Predicate<Throwable> myShouldRetry) {
        try {
            return (T)RetryUtils.retry(() -> this.getDBI().withHandle(callback), myShouldRetry, 10);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

