/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceHealth;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.InstanceHealthDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.SQLUpdatingDataManager;
import io.imply.cloud.persistence.StorageTablesConfig;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.NoResultsException;

@ManageLifecycle
public class SQLInstanceHealthDataManager
extends SQLUpdatingDataManager<InstanceHealth>
implements InstanceHealthDataManager {
    private final String tableName;
    private final JavaType javaType;

    @Inject
    public SQLInstanceHealthDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector, Supplier<StorageTablesConfig> dbTables) {
        super(jsonMapper, connector);
        this.tableName = ((StorageTablesConfig)dbTables.get()).getInstanceHealthTable();
        this.javaType = jsonMapper.getTypeFactory().constructType(InstanceHealth.class);
    }

    @Override
    public InstanceHealth insert(InstanceHealth instanceHealth) {
        return (InstanceHealth)this.dbi.withHandle(handle -> this.insertWithHandle(handle, instanceHealth));
    }

    @Override
    public List<InstanceHealth> getAllFailedInstances() {
        return (List)this.dbi.withHandle(handle -> {
            String query = String.format("SELECT payload FROM %1$s WHERE failure_count >= :maxInstanceFailures", this.getTableName());
            return ((Query)handle.createQuery(query).bind("maxInstanceFailures", 5)).map((index, r, ctx) -> {
                try {
                    InstanceHealth payload = (InstanceHealth)this.jsonMapper.readValue(r.getBytes("payload"), this.getJavaType());
                    return payload;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).list();
        });
    }

    @Override
    public List<InstanceHealth> getAllForCluster(String clusterId) {
        return (List)this.dbi.withHandle(handle -> {
            String query = String.format("SELECT payload FROM %1$s WHERE cluster_id = :clusterId", this.getTableName());
            return ((Query)handle.createQuery(query).bind("clusterId", clusterId)).map((index, r, ctx) -> {
                try {
                    InstanceHealth payload = (InstanceHealth)this.jsonMapper.readValue(r.getBytes("payload"), this.getJavaType());
                    return payload;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).list();
        });
    }

    @Override
    protected String getTableName() {
        return this.tableName;
    }

    @Override
    protected String getMainKeyColumnName() {
        return "key_name";
    }

    @Override
    protected JavaType getJavaType() {
        return this.javaType;
    }

    @Override
    protected void createTable() {
        this.connector.createTable(this.getTableName(), (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (%n  %2$s VARCHAR(100) NOT NULL,%n  cluster_id VARCHAR(50) NOT NULL,%n  instance_id VARCHAR(50) NOT NULL,%n  host VARCHAR(100),%n  imply_node_type VARCHAR(20),%n  created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  last_status_check TIMESTAMP,%n  consecutive_success_count SMALLINT,%n  failure_count SMALLINT,%n  payload %3$s NOT NULL,%n  PRIMARY KEY (%2$s)%n);", this.getTableName(), this.getMainKeyColumnName(), this.connector.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_cluster_id ON %1$s(cluster_id)", this.getTableName())));
    }

    private InstanceHealth insertWithHandle(Handle handle, InstanceHealth instanceHealth) {
        InstanceHealth instanceHealthToInsert = this.existsWithHandle(handle, instanceHealth.getKey(), DeletedVisibility.HIDE) ? ((InstanceHealth)this.getWithHandle(handle, instanceHealth.getKey(), DeletedVisibility.HIDE)).merge(instanceHealth) : InstanceHealth.builder().withInstanceHealth(instanceHealth).withCreated(DateTime.now()).build();
        handle.inTransaction((myHandle, transactionStatus) -> {
            String statement = String.format(!this.existsWithHandle(myHandle, instanceHealth.getKey(), DeletedVisibility.HIDE) ? "INSERT INTO %1$s (%2$s, cluster_id, instance_id, host, imply_node_type, created, last_status_check, consecutive_success_count, failure_count, payload) VALUES (:keyName, :clusterId, :instanceId, :host, :implyNodeType, :created, :lastStatusCheck, :consecutiveSuccessCount, :failureCount, :payload)" : "UPDATE %1$s SET cluster_id=:clusterId,instance_id=:instanceId,host=:host,imply_node_type=:implyNodeType,created=:created,last_status_check=:lastStatusCheck,consecutive_success_count=:consecutiveSuccessCount,failure_count=:failureCount,payload=:payload WHERE %2$s=:keyName", this.getTableName(), this.getMainKeyColumnName());
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)myHandle.createStatement(statement).bind("keyName", instanceHealthToInsert.getKey())).bind("clusterId", instanceHealthToInsert.getClusterId())).bind("instanceId", instanceHealthToInsert.getInstanceId())).bind("host", instanceHealthToInsert.getHost())).bind("implyNodeType", instanceHealthToInsert.getImplyNodeType().capitalCasedName())).bind("created", instanceHealthToInsert.getCreated() != null ? new Timestamp(instanceHealthToInsert.getCreated().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("lastStatusCheck", instanceHealthToInsert.getLastStatusCheck() != null ? new Timestamp(instanceHealthToInsert.getLastStatusCheck().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("consecutiveSuccessCount", instanceHealthToInsert.getConsecutiveSuccessCount())).bind("failureCount", instanceHealthToInsert.getFailureCount())).bind("payload", this.jsonMapper.writeValueAsBytes((Object)instanceHealthToInsert))).execute();
            return null;
        });
        return instanceHealthToInsert;
    }

    @Override
    public InstanceHealth getOrNull(String clusterId, String instanceId, ImplyNodeType implyNodeType) {
        Preconditions.checkNotNull((Object)clusterId, (Object)"clusterId");
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId");
        Preconditions.checkNotNull((Object)implyNodeType, (Object)"implyNodeType");
        try {
            return (InstanceHealth)this.get(InstanceHealth.createKey(clusterId, instanceId, implyNodeType));
        }
        catch (DBIException e) {
            if (e instanceof NoResultsException || e.getCause() instanceof NoResultsException) {
                return null;
            }
            throw e;
        }
    }
}

