/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.exception.AlreadyExistsException;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.ExtendedInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.model.Region;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.ClusterNodesDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.persistence.SQLAppendingDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.StorageTablesConfig;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.NRE;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.util.IntegerColumnMapper;

@ManageLifecycle
public class SQLClusterDataManager
extends SQLAppendingDataManager<Cluster>
implements ClusterDataManager {
    private final String clusterTableName;
    private final JavaType javaType;
    private final EntityStateDataManager entityStateDataManager;
    private final ClusterNodesDataManager clusterNodesDataManager;
    private final ApplicationConfig applicationConfig;

    @Inject
    public SQLClusterDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector, Supplier<StorageTablesConfig> dbTables, EntityStateDataManager entityStateDataManager, ClusterNodesDataManager clusterNodesDataManager, ApplicationConfig applicationConfig) {
        super(jsonMapper, connector);
        this.clusterTableName = ((StorageTablesConfig)dbTables.get()).getClustersTable();
        this.javaType = jsonMapper.getTypeFactory().constructType(Cluster.class);
        this.entityStateDataManager = entityStateDataManager;
        this.clusterNodesDataManager = clusterNodesDataManager;
        this.applicationConfig = applicationConfig;
    }

    @Override
    public ClusterWithExtendedInfo createWithInfo(Cluster cluster, Info info, String createdBy, boolean createEmptyClusterNodesEntry, boolean updateProposedClusterVersion, boolean updateConfigServerClusterVersion, Integer clusterLimit, Region region) {
        return (ClusterWithExtendedInfo)this.dbi.inTransaction(TransactionIsolationLevel.SERIALIZABLE, (handle, transactionStatus) -> {
            if (clusterLimit != null && this.getCountWithAccountIdWithHandle(cluster.getAccountId(), handle, DeletedVisibility.HIDE, region) >= clusterLimit) {
                throw new IAE("Limit of [%d] clusters has been reached", clusterLimit);
            }
            Cluster createdCluster = this.createWithHandle(handle, cluster, createdBy);
            Info.Builder infoToInsert = info.cloner();
            if (createEmptyClusterNodesEntry) {
                ClusterNodes createdClusterNodes = this.clusterNodesDataManager.insert(new ClusterNodes(createdCluster.getClusterId(), null, null, null, (Map<String, NodeConfiguration>)ImmutableMap.of()), createdBy, true, false);
                infoToInsert.withProposedClusterNodesVersion(createdClusterNodes.getVersion());
                infoToInsert.withDeployedClusterNodesVersion(createdClusterNodes.getVersion());
            }
            if (updateProposedClusterVersion) {
                infoToInsert.withProposedClusterVersion(createdCluster.getVersion());
            }
            if (updateConfigServerClusterVersion) {
                infoToInsert.withConfigServerClusterVersion(createdCluster.getVersion());
            }
            Info insertedInfo = this.entityStateDataManager.insertWithHandle(handle, createdCluster.key(), createdCluster.getClusterId(), EntityType.CLUSTER, (Info)infoToInsert.build());
            return ClusterWithExtendedInfo.build(createdCluster, ExtendedInfo.of(insertedInfo), false);
        });
    }

    @Override
    public Cluster update(Cluster cluster, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) {
        return (Cluster)this.dbi.withHandle(handle -> this.updateWithHandle(handle, cluster, updatedBy, autoIncrementVersion, mergeWithPrevious));
    }

    @Override
    public ClusterWithExtendedInfo updateWithInfo(Cluster cluster, Info info, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious, boolean updateDeployedClusterVersion, boolean updateConfigServerClusterVersion, boolean updateProposedClusterVersion) {
        return (ClusterWithExtendedInfo)this.dbi.inTransaction((handle, transactionStatus) -> {
            Cluster updatedCluster = this.updateWithHandle(handle, cluster, updatedBy, autoIncrementVersion, mergeWithPrevious);
            Info.Builder infoToInsert = info.cloner();
            if (updateDeployedClusterVersion) {
                infoToInsert.withDeployedClusterVersion(updatedCluster.getVersion());
            }
            if (updateConfigServerClusterVersion) {
                infoToInsert.withConfigServerClusterVersion(updatedCluster.getVersion());
            }
            if (updateProposedClusterVersion) {
                infoToInsert.withProposedClusterVersion(updatedCluster.getVersion());
            }
            Info insertedInfo = this.entityStateDataManager.insertWithHandle(handle, updatedCluster.key(), updatedCluster.getClusterId(), EntityType.CLUSTER, (Info)infoToInsert.build());
            return ClusterWithExtendedInfo.build(updatedCluster, ExtendedInfo.of(insertedInfo), false);
        });
    }

    @Override
    public String delete(String clusterId, String deletedBy, boolean deleteClusterNodesEntry) {
        return (String)this.dbi.inTransaction((handle, transactionStatus) -> {
            if (deleteClusterNodesEntry) {
                this.clusterNodesDataManager.deleteWithHandle(handle, clusterId, deletedBy);
            }
            this.updateWithHandle(handle, (Cluster)((Cluster.Builder)((Cluster)this.getWithHandle(handle, clusterId, DeletedVisibility.HIDE)).cloner().withComments("[Cluster deleted]")).build(), deletedBy, true, true);
            ((Update)((Update)handle.createStatement(String.format("UPDATE %1$s SET used=:used WHERE %2$s=:key", this.getTableName(), this.getMainKeyColumnName())).bind("used", false)).bind("key", clusterId)).execute();
            return clusterId;
        });
    }

    @Override
    public boolean isDeleted(String clusterId) {
        return this.exists(clusterId, DeletedVisibility.SHOW_ALL) && !this.exists(clusterId, DeletedVisibility.HIDE);
    }

    @Override
    public Cluster getVersionOrNull(String clusterId, int version) {
        return this.getAllVersions(clusterId).stream().filter(x -> x.getVersion().equals(version)).findFirst().orElse(null);
    }

    @Override
    public List<Cluster> getAllWithAccountId(String accountId) {
        return this.getAllWithAccountId(accountId, DeletedVisibility.HIDE);
    }

    @Override
    public List<Cluster> getAllWithAccountId(String accountId, DeletedVisibility deletedVisibility) {
        return (List)this.dbi.withHandle(handle -> this.getAllWithAccountIdWithHandle(accountId, handle, deletedVisibility));
    }

    @Override
    protected String getTableName() {
        return this.clusterTableName;
    }

    @Override
    protected String getMainKeyColumnName() {
        return "cluster_id";
    }

    @Override
    protected JavaType getJavaType() {
        return this.javaType;
    }

    @Override
    protected void createTable() {
        this.connector.createTable(this.getTableName(), (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (%n  %2$s VARCHAR(100) NOT NULL,%n  account_id VARCHAR(100) NOT NULL,%n  version INT NOT NULL,%n  inserted_by VARCHAR(100),%n  updated_by VARCHAR(100),%n  created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  last_modified TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  payload %3$s NOT NULL,%n  used BOOLEAN NOT NULL,%n  cluster_id_version_sha1 VARCHAR(100) NOT NULL,%n  PRIMARY KEY (cluster_id_version_sha1)%n);", this.getTableName(), this.getMainKeyColumnName(), this.connector.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_account_id ON %1$s(account_id)", this.getTableName()), (Object)String.format("CREATE INDEX idx_%1$s_%2$s ON %1$s(%2$s)", this.getTableName(), this.getMainKeyColumnName())));
        this.connector.createIndex(this.getTableName(), String.format("idx_%1$s_%2$s_used_version", this.getTableName(), this.getMainKeyColumnName()), (List<String>)ImmutableList.of((Object)this.getMainKeyColumnName(), (Object)"used", (Object)"version"));
        this.connector.createIndex(this.getTableName(), String.format("idx_%1$s_account_id_used_version", this.getTableName()), (List<String>)ImmutableList.of((Object)"account_id", (Object)"used", (Object)"version"));
    }

    private Cluster createWithHandle(Handle handle, Cluster cluster, String createdBy) throws JsonProcessingException {
        String clusterId = cluster.getClusterId();
        if (this.existsWithHandle(handle, clusterId, DeletedVisibility.SHOW_ALL)) {
            throw new AlreadyExistsException(this.getJavaType().getRawClass(), clusterId);
        }
        List<Cluster> clusters = this.getAllWithAccountIdWithHandle(cluster.getAccountId(), handle, DeletedVisibility.HIDE);
        int clusterNumber = SQLClusterDataManager.findAvailableClusterNumber(clusters, this.applicationConfig.getStartingClusterNumber());
        DateTime now = DateTime.now();
        return this.insertWithHandle(handle, (Cluster)((Cluster.Builder)((Cluster.Builder)((Cluster.Builder)((Cluster.Builder)cluster.cloner().withClusterNumber(clusterNumber)).withVersion(0)).withCreated(now)).withLastModified(now)).build(), createdBy, true);
    }

    private Cluster updateWithHandle(Handle handle, Cluster cluster, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) throws JsonProcessingException {
        String clusterId = cluster.getClusterId();
        if (!this.existsWithHandle(handle, clusterId, DeletedVisibility.HIDE)) {
            throw new NRE(this.getJavaType().getRawClass(), clusterId);
        }
        Cluster previousCluster = (Cluster)this.getWithHandle(handle, clusterId, DeletedVisibility.HIDE);
        if (cluster.getAccountId() != null && !cluster.getAccountId().equals(previousCluster.getAccountId())) {
            throw new IAE("Update failed for cluster [%s]: accountId cannot be modified", clusterId);
        }
        Cluster clusterToUpdate = mergeWithPrevious ? ((Cluster.Builder)previousCluster.cloner().withCluster(cluster, true)).build() : cluster;
        int expectedVersion = previousCluster.getVersion() + 1;
        if (autoIncrementVersion) {
            clusterToUpdate = ((Cluster.Builder)clusterToUpdate.cloner().withVersion(expectedVersion)).build();
        }
        if (clusterToUpdate.getVersion() != expectedVersion) {
            throw new IAE("Update failed for cluster [%s]: received version [%d], expecting version [%d]", clusterId, clusterToUpdate.getVersion(), expectedVersion);
        }
        return this.insertWithHandle(handle, (Cluster)((Cluster.Builder)clusterToUpdate.cloner().withLastModified(DateTime.now())).build(), updatedBy, false);
    }

    private Cluster insertWithHandle(Handle handle, Cluster cluster, String insertedBy, boolean initialCreation) throws JsonProcessingException {
        String clusterId = cluster.getClusterId();
        String clusterIdVersionSha1 = DigestUtils.sha1Hex((String)(clusterId + cluster.getVersion()));
        Object clusterCloner = cluster.cloner().withModifiedBy(insertedBy);
        if (initialCreation) {
            ((Cluster.Builder)clusterCloner).withCreatedBy(insertedBy);
        }
        Object clusterToInsert = ((Cluster.Builder)clusterCloner).build();
        ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %1$s (%2$s, account_id, version, inserted_by, created, last_modified, payload, used, cluster_id_version_sha1) VALUES (:clusterId, :accountId, :version, :insertedBy, :created, :lastModified, :payload, :used, :clusterIdVersionSha1)", this.getTableName(), this.getMainKeyColumnName())).bind("clusterId", clusterId)).bind("accountId", ((Cluster)clusterToInsert).getAccountId())).bind("version", ((Cluster)clusterToInsert).getVersion())).bind("insertedBy", insertedBy)).bind("created", ((Cluster)clusterToInsert).getCreated() != null ? new Timestamp(((Cluster)clusterToInsert).getCreated().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("lastModified", ((Cluster)clusterToInsert).getLastModified() != null ? new Timestamp(((Cluster)clusterToInsert).getLastModified().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("userId", insertedBy)).bind("payload", this.jsonMapper.writeValueAsBytes(clusterToInsert))).bind("used", true)).bind("clusterIdVersionSha1", clusterIdVersionSha1)).execute();
        return clusterToInsert;
    }

    private List<Cluster> getAllWithAccountIdWithHandle(String accountId, Handle handle, DeletedVisibility deletedVisibility) {
        HashMap<String, Object> namedArguments = new HashMap<String, Object>();
        namedArguments.put("accountId", accountId);
        List clusters = ((Query)handle.createQuery(String.format("SELECT r.cluster_id, r.payload FROM %1$s r INNER JOIN(SELECT cluster_id, max(version) as version FROM %1$s WHERE account_id=:accountId %2$s GROUP BY cluster_id) latest ON r.cluster_id = latest.cluster_id and r.version = latest.version ORDER BY created ASC", this.getTableName(), SQLClusterDataManager.buildDeletedFilter(deletedVisibility, namedArguments))).bindFromMap(namedArguments)).map((index, r, ctx) -> {
            try {
                Cluster payload = (Cluster)this.jsonMapper.readValue(r.getBytes("payload"), this.getJavaType());
                return payload;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).list();
        return clusters;
    }

    private int getCountWithAccountIdWithHandle(String accountId, Handle handle, DeletedVisibility deletedVisibility, Region region) {
        HashMap<String, Object> namedArguments = new HashMap<String, Object>();
        namedArguments.put("accountId", accountId);
        if (region != null) {
            namedArguments.put("region", region.getName());
        }
        return (Integer)((Query)handle.createQuery(String.format("SELECT COUNT(DISTINCT(cluster_id)) FROM %1$s WHERE account_id=:accountId %2$s %3$s", this.getTableName(), SQLClusterDataManager.buildDeletedFilter(deletedVisibility, namedArguments), region != null ? "AND JSON_EXTRACT(CONVERT(payload using utf8mb4), '$.region')=:region" : "")).bindFromMap(namedArguments)).map((ResultColumnMapper)IntegerColumnMapper.PRIMITIVE).first();
    }

    static int findAvailableClusterNumber(List<Cluster> clusters, Integer startingClusterNumber) {
        HashSet<Integer> usedClusterNumbers = new HashSet<Integer>();
        for (Cluster cluster : clusters) {
            Integer clusterNumber = cluster.getClusterNumber();
            if (clusterNumber == null) continue;
            usedClusterNumbers.add(clusterNumber);
        }
        if (usedClusterNumbers.isEmpty()) {
            return startingClusterNumber;
        }
        List availableClusterNumbers = IntStream.range(startingClusterNumber, 251).boxed().collect(Collectors.toList());
        availableClusterNumbers.removeAll(usedClusterNumbers);
        if (!availableClusterNumbers.isEmpty()) {
            return (Integer)availableClusterNumbers.get(0);
        }
        throw new ISE("No more cluster numbers available for this account.", new Object[0]);
    }
}

