/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.model.CloudResources;
import io.imply.cloud.persistence.CloudResourcesDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.SQLUpdatingDataManager;
import io.imply.cloud.persistence.StorageTablesConfig;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Update;

@ManageLifecycle
public class SQLCloudResourcesDataManager
extends SQLUpdatingDataManager<CloudResources>
implements CloudResourcesDataManager {
    private final String tableName;
    private final JavaType javaType;
    private final ApplicationConfig applicationConfig;

    @Inject
    public SQLCloudResourcesDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector, Supplier<StorageTablesConfig> dbTables, ApplicationConfig applicationConfig) {
        super(jsonMapper, connector);
        this.tableName = ((StorageTablesConfig)dbTables.get()).getCloudResourcesTable();
        this.javaType = jsonMapper.getTypeFactory().constructType(CloudResources.class);
        this.applicationConfig = applicationConfig;
    }

    @Override
    @LifecycleStart
    public void start() {
        if (this.applicationConfig.isAWS() || this.applicationConfig.isSaaS() || this.applicationConfig.isIOW()) {
            this.createTable();
        }
    }

    @Override
    public CloudResources insert(String key, CloudResources cloudResources) {
        return (CloudResources)this.dbi.withHandle(handle -> this.insertWithHandle(handle, key, cloudResources));
    }

    @Override
    protected String getTableName() {
        return this.tableName;
    }

    @Override
    protected String getMainKeyColumnName() {
        return "key_name";
    }

    @Override
    protected JavaType getJavaType() {
        return this.javaType;
    }

    @Override
    protected void createTable() {
        this.connector.createTable(this.getTableName(), (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (%n  %2$s VARCHAR(100) NOT NULL,%n  last_modified TIMESTAMP,%n  payload %3$s NOT NULL,%n  PRIMARY KEY (%2$s)%n);", this.getTableName(), this.getMainKeyColumnName(), this.connector.getPayloadType())));
    }

    private CloudResources insertWithHandle(Handle handle, String key, CloudResources cloudResources) {
        CloudResources myCloudResources = this.existsWithHandle(handle, key, DeletedVisibility.HIDE) ? ((CloudResources)this.getWithHandle(handle, key, DeletedVisibility.HIDE)).merge(cloudResources) : cloudResources;
        CloudResources cloudResourcesToInsert = CloudResources.builder().withCloudResources(myCloudResources).withLastModified(DateTime.now()).build().removeClearedFields();
        handle.inTransaction((myHandle, transactionStatus) -> {
            String statement = String.format(!this.existsWithHandle(myHandle, key, DeletedVisibility.HIDE) ? "INSERT INTO %1$s (%2$s, last_modified, payload) VALUES (:keyName, :lastModified, :payload)" : "UPDATE %1$s SET last_modified=:lastModified, payload=:payload WHERE %2$s=:keyName", this.getTableName(), this.getMainKeyColumnName());
            ((Update)((Update)((Update)myHandle.createStatement(statement).bind("keyName", key)).bind("lastModified", cloudResourcesToInsert.getLastModified() != null ? new Timestamp(cloudResourcesToInsert.getLastModified().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("payload", this.jsonMapper.writeValueAsBytes((Object)cloudResourcesToInsert))).execute();
            return null;
        });
        return cloudResourcesToInsert;
    }
}

