/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.model.BillingEntry;
import io.imply.cloud.persistence.BillingDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.StorageTablesConfig;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;

@ManageLifecycle
public class SQLBillingDataManager
implements BillingDataManager {
    private final ObjectMapper jsonMapper;
    private final SQLStorageConnector connector;
    private final IDBI dbi;
    private final String billingTableName;
    private final ApplicationConfig applicationConfig;

    @Inject
    public SQLBillingDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector, Supplier<StorageTablesConfig> dbTables, ApplicationConfig applicationConfig) {
        this.jsonMapper = jsonMapper;
        this.connector = connector;
        this.dbi = connector.getDBI();
        this.billingTableName = ((StorageTablesConfig)dbTables.get()).getBillingTable();
        this.applicationConfig = applicationConfig;
    }

    @LifecycleStart
    public void start() {
        if (!this.applicationConfig.isOnPrem()) {
            this.createTable();
        }
    }

    @Override
    public BillingEntry insert(BillingEntry billingEntry) {
        return (BillingEntry)this.dbi.withHandle(handle -> this.insertWithHandle(handle, billingEntry));
    }

    @Override
    public BillingEntry insertWithHandle(Handle handle, BillingEntry billingEntry) throws JsonProcessingException {
        ((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %s (principal_id, account_id, timestamp, payload) VALUES (:principalId, :accountId, :timestamp, :payload)", this.getTableName())).bind("principalId", billingEntry.getPrincipalId())).bind("accountId", billingEntry.getAccountId())).bind("timestamp", new Timestamp(billingEntry.getTimestamp().toDateTime(DateTimeZone.UTC).getMillis()))).bind("payload", this.jsonMapper.writeValueAsBytes((Object)billingEntry))).execute();
        return billingEntry;
    }

    @Override
    public List<BillingEntry> getAllWithAccountId(String accountId) {
        return (List)this.dbi.withHandle(handle -> this.getAllWithAccountIdWithHandle(accountId, handle));
    }

    private List<BillingEntry> getAllWithAccountIdWithHandle(String accountId, Handle handle) {
        return ((Query)handle.createQuery(String.format("SELECT payload FROM %1$s WHERE account_id=:accountId ORDER BY timestamp ASC", this.getTableName())).bind("accountId", accountId)).map((index, r, ctx) -> {
            try {
                BillingEntry payload = (BillingEntry)this.jsonMapper.readValue(r.getBytes("payload"), BillingEntry.class);
                return payload;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).list();
    }

    private String getTableName() {
        return this.billingTableName;
    }

    private void createTable() {
        this.connector.createTable(this.getTableName(), (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (%n  id %2$s NOT NULL,%n  principal_id VARCHAR(100),%n  account_id VARCHAR(100) NOT NULL,%n  timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  payload %3$s NOT NULL,%n  PRIMARY KEY (id)%n);", this.getTableName(), this.connector.getSerialType(), this.connector.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_account_id ON %1$s(account_id)", this.getTableName())));
    }
}

