/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.model.AuditEntry;
import io.imply.cloud.persistence.AuditDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.StorageTablesConfig;
import java.io.IOException;
import java.sql.Timestamp;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.NoResultsException;

@ManageLifecycle
public class SQLAuditDataManager
implements AuditDataManager {
    private final ObjectMapper jsonMapper;
    private final SQLStorageConnector connector;
    private final IDBI dbi;
    private final String auditTableName;

    @Inject
    public SQLAuditDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector, Supplier<StorageTablesConfig> dbTables) {
        this.jsonMapper = jsonMapper;
        this.connector = connector;
        this.dbi = connector.getDBI();
        this.auditTableName = ((StorageTablesConfig)dbTables.get()).getAuditTable();
    }

    @LifecycleStart
    public void start() {
        this.createTable();
    }

    @Override
    public String insert(AuditEntry auditEntry) {
        return (String)this.dbi.withHandle(handle -> {
            ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %s (request_id, principal_id, account_id, action, timestamp, payload) VALUES (:requestId, :principalId, :accountId, :action, :timestamp, :payload)", this.getTableName())).bind("requestId", auditEntry.getRequestId())).bind("principalId", auditEntry.getPrincipalId())).bind("accountId", auditEntry.getAccountId())).bind("action", auditEntry.getAction())).bind("timestamp", new Timestamp(auditEntry.getTimestamp().toDateTime(DateTimeZone.UTC).getMillis()))).bind("payload", this.jsonMapper.writeValueAsBytes((Object)auditEntry))).execute();
            return auditEntry.getRequestId();
        });
    }

    @Override
    public AuditEntry get(String requestId) {
        return (AuditEntry)this.dbi.withHandle(handle -> {
            AuditEntry retVal = (AuditEntry)((Query)handle.createQuery(String.format("SELECT payload FROM %1$s WHERE request_id=:key", this.getTableName())).bind("key", requestId)).map((index, r, ctx) -> {
                try {
                    return (AuditEntry)this.jsonMapper.readValue(r.getBytes("payload"), AuditEntry.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).first();
            if (retVal == null) {
                throw new NoResultsException(requestId, null);
            }
            return retVal;
        });
    }

    private String getTableName() {
        return this.auditTableName;
    }

    private void createTable() {
        this.connector.createTable(this.getTableName(), (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (%n  id %2$s NOT NULL,%n  request_id VARCHAR(100) NOT NULL,%n  principal_id VARCHAR(100) NOT NULL,%n  account_id VARCHAR(100),%n  action VARCHAR(100) NOT NULL,%n  timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  payload %3$s NOT NULL,%n  PRIMARY KEY (id)%n);", this.getTableName(), this.connector.getSerialType(), this.connector.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_account_id ON %1$s(account_id)", this.getTableName()), (Object)String.format("CREATE INDEX idx_%1$s_request_id ON %1$s(request_id)", this.getTableName())));
    }
}

