/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.exception.AlreadyExistsException;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.AccountWithExtendedInfo;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.ExtendedInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.persistence.SQLAppendingDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.StorageTablesConfig;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.NRE;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Update;

@ManageLifecycle
public class SQLAccountDataManager
extends SQLAppendingDataManager<Account>
implements AccountDataManager {
    private final String accountTableName;
    private final JavaType javaType;
    private final EntityStateDataManager entityStateDataManager;

    @Inject
    public SQLAccountDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector, Supplier<StorageTablesConfig> dbTables, EntityStateDataManager entityStateDataManager) {
        super(jsonMapper, connector);
        this.accountTableName = ((StorageTablesConfig)dbTables.get()).getAccountsTable();
        this.javaType = jsonMapper.getTypeFactory().constructType(Account.class);
        this.entityStateDataManager = entityStateDataManager;
    }

    @Override
    public AccountWithExtendedInfo createWithInfo(Account account, Info info, String createdBy) {
        return (AccountWithExtendedInfo)this.dbi.inTransaction((handle, transactionStatus) -> {
            Account createdAccount = this.createWithHandle(handle, account, createdBy);
            Info insertedInfo = this.entityStateDataManager.insertWithHandle(handle, createdAccount.key(), createdAccount.getAccountId(), EntityType.ACCOUNT, info);
            return AccountWithExtendedInfo.build(createdAccount, ExtendedInfo.of(insertedInfo), false);
        });
    }

    @Override
    public Account update(Account account, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) {
        return (Account)this.dbi.withHandle(handle -> this.updateWithHandle(handle, account, updatedBy, autoIncrementVersion, mergeWithPrevious));
    }

    @Override
    protected String getTableName() {
        return this.accountTableName;
    }

    @Override
    protected String getMainKeyColumnName() {
        return "account_id";
    }

    @Override
    protected JavaType getJavaType() {
        return this.javaType;
    }

    @Override
    protected void createTable() {
        this.connector.createTable(this.getTableName(), (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (%n  %2$s VARCHAR(100) NOT NULL,%n  version INT NOT NULL,%n  inserted_by VARCHAR(100),%n  updated_by VARCHAR(100),%n  created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  last_modified TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  payload %3$s NOT NULL,%n  used BOOLEAN NOT NULL,%n  account_id_version_sha1 VARCHAR(100) NOT NULL,%n  PRIMARY KEY (account_id_version_sha1)%n);", this.getTableName(), this.getMainKeyColumnName(), this.connector.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_%2$s ON %1$s(%2$s)", this.getTableName(), this.getMainKeyColumnName())));
        this.connector.createIndex(this.getTableName(), String.format("idx_%1$s_%2$s_used_version", this.getTableName(), this.getMainKeyColumnName()), (List<String>)ImmutableList.of((Object)this.getMainKeyColumnName(), (Object)"used", (Object)"version"));
    }

    private Account createWithHandle(Handle handle, Account account, String createdBy) throws JsonProcessingException {
        String accountId = account.getAccountId();
        if (this.existsWithHandle(handle, accountId, DeletedVisibility.SHOW_ALL)) {
            throw new AlreadyExistsException(this.getJavaType().getRawClass(), accountId);
        }
        Account accountToInsert = accountId == null ? ((Account.Builder)account.cloner().withAccountId(this.generateUUIDWithHandle(handle))).build() : account;
        DateTime now = DateTime.now();
        return this.insertWithHandle(handle, (Account)((Account.Builder)((Account.Builder)((Account.Builder)accountToInsert.cloner().withVersion(0)).withCreated(now)).withLastModified(now)).build(), createdBy);
    }

    private Account updateWithHandle(Handle handle, Account account, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) throws JsonProcessingException {
        String accountId = account.getAccountId();
        if (!this.existsWithHandle(handle, accountId, DeletedVisibility.HIDE)) {
            throw new NRE(this.getJavaType().getRawClass(), accountId);
        }
        Account previousAccount = (Account)this.getWithHandle(handle, accountId, DeletedVisibility.HIDE);
        Account accountToUpdate = mergeWithPrevious ? ((Account.Builder)previousAccount.cloner().withAccount(account, true)).build() : account;
        int expectedVersion = previousAccount.getVersion() + 1;
        if (autoIncrementVersion) {
            accountToUpdate = ((Account.Builder)accountToUpdate.cloner().withVersion(expectedVersion)).build();
        }
        if (accountToUpdate.getVersion() != expectedVersion) {
            throw new IAE("Update failed for account [%s]: received version [%d], expecting version [%d]", accountId, accountToUpdate.getVersion(), expectedVersion);
        }
        return this.insertWithHandle(handle, (Account)((Account.Builder)accountToUpdate.cloner().withLastModified(DateTime.now())).build(), updatedBy);
    }

    private Account insertWithHandle(Handle handle, Account account, String insertedBy) throws JsonProcessingException {
        Object accountToInsert = ((Account.Builder)account.cloner().removeClearedFields()).build();
        String accountId = ((Account)accountToInsert).getAccountId();
        String accountIdVersionSha1 = DigestUtils.sha1Hex((String)(accountId + ((Account)accountToInsert).getVersion()));
        ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %1$s (%2$s, version, inserted_by, created, last_modified, payload, used, account_id_version_sha1) VALUES (:accountId, :version, :insertedBy, :created, :lastModified, :payload, :used, :accountIdVersionSha1)", this.getTableName(), this.getMainKeyColumnName())).bind("accountId", accountId)).bind("version", ((Account)accountToInsert).getVersion())).bind("insertedBy", insertedBy)).bind("created", ((Account)accountToInsert).getCreated() != null ? new Timestamp(((Account)accountToInsert).getCreated().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("lastModified", ((Account)accountToInsert).getLastModified() != null ? new Timestamp(((Account)accountToInsert).getLastModified().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("payload", this.jsonMapper.writeValueAsBytes(accountToInsert))).bind("used", true)).bind("accountIdVersionSha1", accountIdVersionSha1)).execute();
        return accountToInsert;
    }
}

