/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.imply.cloud.cache.Cache;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.guice.JsonConfigProvider;
import io.imply.cloud.guice.LifecycleModule;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.AuditDataManager;
import io.imply.cloud.persistence.BillingDataManager;
import io.imply.cloud.persistence.BillingEntityStateDataManager;
import io.imply.cloud.persistence.CloudResourcesDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.ClusterNodesDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.persistence.InstanceHealthDataManager;
import io.imply.cloud.persistence.NoopBillingDataManager;
import io.imply.cloud.persistence.NoopCloudResourcesDataManager;
import io.imply.cloud.persistence.NotificationDataManager;
import io.imply.cloud.persistence.SQLAccountDataManager;
import io.imply.cloud.persistence.SQLAuditDataManager;
import io.imply.cloud.persistence.SQLBillingDataManager;
import io.imply.cloud.persistence.SQLCloudResourcesDataManager;
import io.imply.cloud.persistence.SQLClusterDataManager;
import io.imply.cloud.persistence.SQLClusterNodesDataManager;
import io.imply.cloud.persistence.SQLEntityStateDataManager;
import io.imply.cloud.persistence.SQLInstanceHealthDataManager;
import io.imply.cloud.persistence.SQLNotificationDataManager;
import io.imply.cloud.persistence.SQLUserDataManager;
import io.imply.cloud.persistence.StorageConnectorConfig;
import io.imply.cloud.persistence.StorageTablesConfig;
import io.imply.cloud.persistence.TransformingClusterDataManager;
import io.imply.cloud.persistence.TransformingEntityStateDataManager;
import io.imply.cloud.persistence.UserDataManager;
import io.imply.cloud.persistence.cache.CachedAccountDataManager;
import io.imply.cloud.persistence.cache.CachedClusterDataManager;
import io.imply.cloud.persistence.cache.CachedClusterNodesDataManager;
import io.imply.cloud.persistence.cache.CachedEntityStateDataManager;
import io.imply.cloud.persistence.cache.CachedInstanceHealthDataManager;
import io.imply.cloud.persistence.cache.CachedNotificationDataManager;
import io.imply.cloud.persistence.cache.CachedUserDataManager;
import io.imply.cloud.persistence.postgresql.PostgreSQLTablesConfig;
import io.imply.cloud.security.DruidAuthManager;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class PersistenceModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "storage.tables", StorageTablesConfig.class);
        JsonConfigProvider.bind(binder, "postgresql.tables", PostgreSQLTablesConfig.class);
        JsonConfigProvider.bind(binder, "storage.connector", StorageConnectorConfig.class);
        binder.bind(AccountDataManager.class).annotatedWith(Internal.class).to(SQLAccountDataManager.class).in(LazySingleton.class);
        binder.bind(UserDataManager.class).annotatedWith(Internal.class).to(SQLUserDataManager.class).in(LazySingleton.class);
        binder.bind(ClusterDataManager.class).annotatedWith(Internal.class).to(SQLClusterDataManager.class).in(LazySingleton.class);
        binder.bind(ClusterNodesDataManager.class).annotatedWith(Internal.class).to(SQLClusterNodesDataManager.class).in(LazySingleton.class);
        binder.bind(NotificationDataManager.class).annotatedWith(Internal.class).to(SQLNotificationDataManager.class).in(LazySingleton.class);
        binder.bind(EntityStateDataManager.class).annotatedWith(Internal.class).to(SQLEntityStateDataManager.class).in(LazySingleton.class);
        binder.bind(InstanceHealthDataManager.class).annotatedWith(Internal.class).to(SQLInstanceHealthDataManager.class).in(LazySingleton.class);
        binder.bind(CloudResourcesDataManager.class).annotatedWith(Internal.class).to(SQLCloudResourcesDataManager.class).in(LazySingleton.class);
        binder.bind(BillingDataManager.class).annotatedWith(Internal.class).to(SQLBillingDataManager.class).in(LazySingleton.class);
        binder.bind(AuditDataManager.class).to(SQLAuditDataManager.class).in(LazySingleton.class);
        LifecycleModule.register(binder, AccountDataManager.class);
        LifecycleModule.register(binder, UserDataManager.class);
        LifecycleModule.register(binder, ClusterDataManager.class);
        LifecycleModule.register(binder, ClusterNodesDataManager.class);
        LifecycleModule.register(binder, NotificationDataManager.class);
        LifecycleModule.register(binder, EntityStateDataManager.class);
        LifecycleModule.register(binder, InstanceHealthDataManager.class);
        LifecycleModule.register(binder, CloudResourcesDataManager.class);
        LifecycleModule.register(binder, BillingDataManager.class);
        LifecycleModule.register(binder, AuditDataManager.class);
    }

    @Provides
    @LazySingleton
    public AccountDataManager getAccountDataManager(@Internal AccountDataManager accountDataManager, ApplicationConfig applicationConfig, ObjectMapper objectMapper, Cache cache) {
        return applicationConfig.isDisablePersistenceCache() ? accountDataManager : new CachedAccountDataManager(accountDataManager, cache, objectMapper);
    }

    @Provides
    @LazySingleton
    public UserDataManager getUserDataManager(@Internal UserDataManager userDataManager, ApplicationConfig applicationConfig, ObjectMapper objectMapper, Cache cache) {
        return applicationConfig.isDisablePersistenceCache() ? userDataManager : new CachedUserDataManager(userDataManager, cache, objectMapper);
    }

    @Provides
    @LazySingleton
    public ClusterDataManager getClusterDataManager(@Internal ClusterDataManager clusterDataManager, SecurityConfig securityConfig, DruidAuthManager druidAuthManager, ApplicationConfig applicationConfig, ObjectMapper objectMapper, Cache cache) {
        TransformingClusterDataManager transformingClusterDataManager = new TransformingClusterDataManager(clusterDataManager, securityConfig, druidAuthManager);
        return applicationConfig.isDisablePersistenceCache() ? transformingClusterDataManager : new CachedClusterDataManager(transformingClusterDataManager, cache, objectMapper);
    }

    @Provides
    @LazySingleton
    public ClusterNodesDataManager getClusterNodesDataManager(@Internal ClusterNodesDataManager clusterNodesDataManager, ApplicationConfig applicationConfig, ObjectMapper objectMapper, Cache cache) {
        return applicationConfig.isDisablePersistenceCache() ? clusterNodesDataManager : new CachedClusterNodesDataManager(clusterNodesDataManager, cache, objectMapper);
    }

    @Provides
    @LazySingleton
    public NotificationDataManager getNotificationDataManager(@Internal NotificationDataManager notificationDataManager, ApplicationConfig applicationConfig, ObjectMapper objectMapper, Cache cache) {
        return applicationConfig.isDisablePersistenceCache() ? notificationDataManager : new CachedNotificationDataManager(notificationDataManager, cache, objectMapper);
    }

    @Provides
    @LazySingleton
    public EntityStateDataManager getEntityStateDataManager(@Internal EntityStateDataManager entityStateDataManager, BillingDataManager billingDataManager, ClusterDataManager clusterDataManager, ApplicationConfig applicationConfig, ObjectMapper objectMapper, Cache cache) {
        TransformingEntityStateDataManager transformingEntityStateDataManager = new TransformingEntityStateDataManager(new BillingEntityStateDataManager(entityStateDataManager, billingDataManager, clusterDataManager, applicationConfig));
        return applicationConfig.isDisablePersistenceCache() ? transformingEntityStateDataManager : new CachedEntityStateDataManager(transformingEntityStateDataManager, cache, objectMapper);
    }

    @Provides
    @LazySingleton
    public InstanceHealthDataManager getInstanceHealthDataManager(@Internal InstanceHealthDataManager instanceHealthDataManager, ApplicationConfig applicationConfig, ObjectMapper objectMapper, Cache cache) {
        return applicationConfig.isDisablePersistenceCache() ? instanceHealthDataManager : new CachedInstanceHealthDataManager(instanceHealthDataManager, cache, objectMapper);
    }

    @Provides
    @LazySingleton
    public CloudResourcesDataManager getCloudResourcesDataManager(@Internal CloudResourcesDataManager cloudResourcesDataManager, ApplicationConfig applicationConfig) {
        return applicationConfig.isAWS() || applicationConfig.isSaaS() || applicationConfig.isIOW() ? cloudResourcesDataManager : new NoopCloudResourcesDataManager();
    }

    @Provides
    @LazySingleton
    public BillingDataManager getBillingDataManager(@Internal BillingDataManager billingDataManager, ApplicationConfig applicationConfig) {
        return applicationConfig.isOnPrem() ? new NoopBillingDataManager() : billingDataManager;
    }

    @BindingAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Internal {
    }
}

