/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.model.BillingEntry;
import io.imply.cloud.model.BillingState;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.persistence.BillingDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.ObjectUtils;
import org.skife.jdbi.v2.Handle;

public class BillingEntityStateDataManager
implements EntityStateDataManager {
    private static final Logger log = new Logger(BillingEntityStateDataManager.class);
    private final EntityStateDataManager entityStateDataManager;
    private final BillingDataManager billingDataManager;
    private final ClusterDataManager clusterDataManager;
    private final ApplicationConfig applicationConfig;

    public BillingEntityStateDataManager(EntityStateDataManager entityStateDataManager, BillingDataManager billingDataManager, ClusterDataManager clusterDataManager, ApplicationConfig applicationConfig) {
        this.entityStateDataManager = entityStateDataManager;
        this.billingDataManager = billingDataManager;
        this.clusterDataManager = clusterDataManager;
        this.applicationConfig = applicationConfig;
    }

    @Override
    public Info insert(String entityKey, String entityId, EntityType entityType, Info entityState, Consumer<Handle> inTxn) {
        inTxn = (Consumer)ObjectUtils.defaultIfNull(inTxn, handle -> {});
        return this.entityStateDataManager.insert(entityKey, entityId, entityType, entityState, inTxn.andThen(handle -> this.maybeAddBillingEntry(entityId, entityType, entityState, (Handle)handle, this.getDetailedUserId(), this.getRequestId())));
    }

    @Override
    public Info insertWithHandle(Handle handle, String entityKey, String entityId, EntityType entityType, Info entityState) {
        this.maybeAddBillingEntry(entityId, entityType, entityState, handle, this.getDetailedUserId(), this.getRequestId());
        return this.entityStateDataManager.insertWithHandle(handle, entityKey, entityId, entityType, entityState);
    }

    @Override
    public Info get(String entityId) {
        return this.entityStateDataManager.get(entityId);
    }

    @Override
    public Info getOrNull(String entityId) {
        return this.entityStateDataManager.getOrNull(entityId);
    }

    @Override
    public String delete(String entityId) {
        return this.entityStateDataManager.delete(entityId);
    }

    @Override
    public List<Info> getAllWithType(EntityType entityType) {
        return this.entityStateDataManager.getAllWithType(entityType);
    }

    @Override
    public List<Info> getAllInTransitionStates() {
        return this.entityStateDataManager.getAllInTransitionStates();
    }

    private String getDetailedUserId() {
        return ThreadLocalContext.getPrincipal() == null ? null : ThreadLocalContext.getPrincipal().getDetailedUserId();
    }

    private String getRequestId() {
        return ThreadLocalContext.getRequestId();
    }

    private void maybeAddBillingEntry(String entityId, EntityType entityType, Info entityState, Handle handle, String userId, String requestId) {
        if (this.applicationConfig.isOnPrem() || !EntityType.CLUSTER.equals((Object)entityType) || entityState == null || entityState.getState() == null || !entityState.getState().isFinalState() && !entityState.getState().isUserInitiated()) {
            return;
        }
        Info previousInfo = this.entityStateDataManager.getOrNull(entityId);
        if (previousInfo != null && entityState.getState().equals((Object)previousInfo.getState())) {
            return;
        }
        State state = entityState.getState();
        BillingState billingState = null;
        switch (state) {
            case CLUSTER_CREATED: 
            case CLUSTER_STARTED: {
                billingState = BillingState.CLUSTER_STARTED;
                break;
            }
            case CLUSTER_DELETED: 
            case CLUSTER_STOPPED: 
            case CLUSTER_PAUSED: {
                billingState = BillingState.CLUSTER_STOPPED;
                break;
            }
            case CLUSTER_UPDATED: {
                billingState = BillingState.CLUSTER_UPDATED;
                break;
            }
            case CLUSTER_DELETE_ROLLED_BACK: 
            case CLUSTER_STOP_ROLLED_BACK: 
            case CLUSTER_UPDATE_ROLLED_BACK: {
                billingState = BillingState.OPERATION_ROLLED_BACK;
                break;
            }
            case CLUSTER_UPDATE_FAILED: 
            case CLUSTER_CREATION_FAILED: 
            case CLUSTER_DELETE_FAILED: 
            case CLUSTER_STOP_FAILED: 
            case CLUSTER_START_FAILED: {
                billingState = BillingState.OPERATION_FAILED;
                break;
            }
            case CLUSTER_INFO_RECEIVED: 
            case CLUSTER_START_REQUEST_RECEIVED: {
                billingState = BillingState.CLUSTER_START_REQUESTED;
                break;
            }
            case CLUSTER_DELETE_REQUEST_RECEIVED: 
            case CLUSTER_STOP_REQUEST_RECEIVED: {
                billingState = BillingState.CLUSTER_STOP_REQUESTED;
                break;
            }
            case CLUSTER_UPDATE_REQUEST_RECEIVED: {
                billingState = BillingState.CLUSTER_UPDATE_REQUESTED;
                break;
            }
            case CLUSTER_UPDATE_FAILED_PROMPT_USER: 
            case CLUSTER_RETRY_UPDATE_REQUEST_RECEIVED: 
            case CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED: 
            case CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED: 
            case CLUSTER_RESTART_REQUEST_RECEIVED: 
            case PLAN_RDS_UPDATE: 
            case RDS_UPDATED: {
                break;
            }
            default: {
                log.warn("Unhandled final-type state [%s] for cluster [%s]", new Object[]{state, entityId});
            }
        }
        if (billingState != null) {
            Cluster cluster = this.clusterDataManager.getOrNullWithHandle(handle, entityId, DeletedVisibility.HIDE);
            if (cluster == null) {
                log.error("null cluster while generating billing entry for cluster [%s]", entityId);
                return;
            }
            BillingEntry billingEntry = BillingEntry.of(userId, cluster.getAccountId(), requestId, billingState, cluster);
            try {
                if (handle != null) {
                    this.billingDataManager.insertWithHandle(handle, billingEntry.validate());
                } else {
                    this.billingDataManager.insert(billingEntry.validate());
                }
            }
            catch (Exception e) {
                log.error(e, "BillingEntry validation or insertion failed for %s", billingEntry);
            }
        }
    }
}

