/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.zookeeper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.Mergeable;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.zookeeper.ExternalZooKeeper;
import io.imply.cloud.model.zookeeper.ManagedZooKeeper;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.Diffable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="managed", value=ManagedZooKeeper.class), @JsonSubTypes.Type(name="external", value=ExternalZooKeeper.class)})
public interface ZooKeeper
extends Mergeable<ZooKeeper>,
Diffable<ZooKeeper> {
    public void validate(List<ImplyConstraintViolation> var1);

    public ZooKeeper merge(ZooKeeper var1);

    @Override
    public ZooKeeper mergeDiff(ZooKeeper var1);

    public ZooKeeper filterNonNullFields(ZooKeeper var1);

    public ZooKeeper withDefaultsForUnset();

    @Override
    public boolean isEmpty();

    default public List<Set<UpdateDetails>> getSupportedUpdatesForDiff(Cluster previousCluster) {
        return this.isEmpty() ? ImmutableList.of() : ZooKeeper.getSupportedUpdates();
    }

    default public List<Set<UpdateDetails>> getSupportedUpdatesForDiff(Diff<ZooKeeper> diff) {
        return ZooKeeper.getSupportedUpdates();
    }

    public static List<Set<UpdateDetails>> getSupportedUpdates() {
        return ImmutableList.of((Object)ImmutableSet.of((Object)UpdateDetails.hard(10, "Changes to ZooKeeper configuration other than adding nodes requires a cluster restart")));
    }
}

