/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.zookeeper;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.zookeeper.ZooKeeper;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ReflectionDiffBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExternalZooKeeper
implements ZooKeeper {
    private final String hosts;
    private final String basePath;

    @JsonCreator
    public ExternalZooKeeper(@JsonProperty(value="hosts") String hosts, @JsonProperty(value="basePath") String basePath) {
        this.hosts = hosts;
        this.basePath = basePath;
    }

    @JsonProperty
    public String getHosts() {
        return this.hosts;
    }

    @JsonProperty
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public ZooKeeper merge(ZooKeeper other) {
        if (other == null) {
            return this;
        }
        if (!(other instanceof ExternalZooKeeper)) {
            return other;
        }
        ExternalZooKeeper externalZkOther = (ExternalZooKeeper)other;
        return new ExternalZooKeeper(externalZkOther.hosts != null ? externalZkOther.hosts : this.hosts, externalZkOther.basePath != null ? externalZkOther.basePath : this.basePath);
    }

    @Override
    public ZooKeeper mergeDiff(ZooKeeper other) {
        if (other == null || !(other instanceof ExternalZooKeeper)) {
            return this;
        }
        ExternalZooKeeper externalZkOther = (ExternalZooKeeper)other;
        return new ExternalZooKeeper(this.hosts == null ? null : (this.hosts.equals(externalZkOther.hosts) ? null : this.hosts), this.basePath == null ? null : (this.basePath.equals(externalZkOther.basePath) ? null : this.basePath));
    }

    public DiffResult<ZooKeeper> diff(ZooKeeper other) {
        return new ReflectionDiffBuilder((Object)this, (Object)other, ToStringStyle.SHORT_PREFIX_STYLE).build();
    }

    @Override
    public ZooKeeper filterNonNullFields(ZooKeeper filter) {
        if (filter == null || !(filter instanceof ExternalZooKeeper)) {
            return new ExternalZooKeeper(null, null);
        }
        ExternalZooKeeper externalZkFilter = (ExternalZooKeeper)filter;
        return new ExternalZooKeeper(externalZkFilter.hosts == null ? null : this.hosts, externalZkFilter.basePath == null ? null : this.basePath);
    }

    @Override
    public ZooKeeper withDefaultsForUnset() {
        return this;
    }

    @Override
    public void validate(List<ImplyConstraintViolation> results) {
        if (this.hosts == null || this.hosts.isEmpty()) {
            results.add(ImplyConstraintViolation.error("zooKeeper.hosts", "[zooKeeper.hosts] cannot be empty", new Object[0]));
        }
        if (this.basePath == null || this.basePath.isEmpty()) {
            results.add(ImplyConstraintViolation.error("zooKeeper.basePath", "[zooKeeper.basePath] cannot be empty", new Object[0]));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.hosts == null && this.basePath == null;
    }

    @Override
    public List<Set<UpdateDetails>> getSupportedUpdatesForDiff(Cluster previousCluster) {
        if (this.isEmpty()) {
            return ImmutableList.of();
        }
        if (previousCluster != null && previousCluster.getZooKeeper() instanceof ExternalZooKeeper) {
            ExternalZooKeeper previousZooKeeper = (ExternalZooKeeper)previousCluster.getZooKeeper();
            if (this.hosts != null && previousZooKeeper.hosts != null) {
                List originalHosts = Arrays.stream(previousZooKeeper.hosts.split(",")).map(String::trim).collect(Collectors.toList());
                originalHosts.retainAll(Arrays.stream(this.hosts.split(",")).map(String::trim).collect(Collectors.toList()));
                if (!originalHosts.isEmpty()) {
                    return ImmutableList.of((Object)ImmutableSet.of((Object)UpdateDetails.hard(10), (Object)UpdateDetails.rolling(999)));
                }
            }
        }
        return ImmutableList.of((Object)ImmutableSet.of((Object)UpdateDetails.hard(10, "Changes to ZooKeeper configuration other than adding nodes requires a cluster restart")));
    }

    @Override
    public List<Set<UpdateDetails>> getSupportedUpdatesForDiff(Diff<ZooKeeper> diff) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return new ToStringBuilder(this).append("hosts", this.hosts).append("basePath", (Object)this.basePath).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalZooKeeper that = (ExternalZooKeeper)o;
        return Objects.equals(this.hosts, that.hosts) && Objects.equals(this.basePath, that.basePath);
    }

    public int hashCode() {
        return Objects.hash(this.hosts);
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().hosts(this.hosts).basePath(this.basePath);
    }

    @Generated
    public static class Builder {
        @Generated
        private String hosts;
        @Generated
        private String basePath;

        @Generated
        Builder() {
        }

        @Generated
        public Builder hosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        @Generated
        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public ExternalZooKeeper build() {
            return new ExternalZooKeeper(this.hosts, this.basePath);
        }

        @Generated
        public String toString() {
            return "ExternalZooKeeper.Builder(hosts=" + this.hosts + ", basePath=" + this.basePath + ")";
        }
    }
}

