/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.usage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.model.BillingEntry;
import io.imply.cloud.model.BillingState;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UsageReportEvent {
    private final String userId;
    private final String requestId;
    private final BillingState billingState;
    private final DateTime timestamp;
    private final String masterInstanceType;
    private final Integer masterInstanceCount;
    private final String queryInstanceType;
    private final Integer queryInstanceCount;
    private final Map<Integer, InstanceTier> dataInstanceTiers;

    @JsonCreator
    public UsageReportEvent(@JsonProperty(value="userId") String userId, @JsonProperty(value="requestId") String requestId, @JsonProperty(value="billingState") BillingState billingState, @JsonProperty(value="timestamp") DateTime timestamp, @JsonProperty(value="masterInstanceType") String masterInstanceType, @JsonProperty(value="masterInstanceCount") Integer masterInstanceCount, @JsonProperty(value="queryInstanceType") String queryInstanceType, @JsonProperty(value="queryInstanceCount") Integer queryInstanceCount, @JsonProperty(value="dataInstanceTiers") Map<Integer, InstanceTier> dataInstanceTiers) {
        this.userId = userId;
        this.requestId = requestId;
        this.billingState = billingState;
        this.timestamp = timestamp;
        this.masterInstanceType = masterInstanceType;
        this.masterInstanceCount = masterInstanceCount;
        this.queryInstanceType = queryInstanceType;
        this.queryInstanceCount = queryInstanceCount;
        this.dataInstanceTiers = dataInstanceTiers;
    }

    @JsonProperty
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty
    public String getRequestId() {
        return this.requestId;
    }

    @JsonProperty
    public BillingState getBillingState() {
        return this.billingState;
    }

    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    @JsonProperty
    public Integer getMasterInstanceCount() {
        return this.masterInstanceCount;
    }

    @JsonProperty
    public String getQueryInstanceType() {
        return this.queryInstanceType;
    }

    @JsonProperty
    public Integer getQueryInstanceCount() {
        return this.queryInstanceCount;
    }

    @JsonProperty
    public Map<Integer, InstanceTier> getDataInstanceTiers() {
        return this.dataInstanceTiers;
    }

    public String toString() {
        return new ToStringBuilder(this).append("userId", this.userId).append("requestId", (Object)this.requestId).append("billingState", (Object)this.billingState).append("timestamp", (Object)this.timestamp).append("masterInstanceType", (Object)this.masterInstanceType).append("masterInstanceCount", (Object)this.masterInstanceCount).append("queryInstanceType", (Object)this.queryInstanceType).append("queryInstanceCount", (Object)this.queryInstanceCount).append("dataInstanceTiers", this.dataInstanceTiers).toString();
    }

    public static UsageReportEvent fromBillingEntry(BillingEntry entry) {
        if (entry == null) {
            return new UsageReportEvent(null, null, null, null, null, null, null, null, null);
        }
        if (!ImmutableSet.of((Object)((Object)BillingState.CLUSTER_STARTED), (Object)((Object)BillingState.CLUSTER_UPDATED)).contains((Object)entry.getState()) || entry.getCluster() == null) {
            return new UsageReportEvent(entry.getPrincipalId(), entry.getRequestId(), entry.getState(), entry.getTimestamp(), null, null, null, null, null);
        }
        Cluster cluster = entry.getCluster();
        return new UsageReportEvent(entry.getPrincipalId(), entry.getRequestId(), entry.getState(), entry.getTimestamp(), cluster.getMasterInstanceType(), cluster.getMasterInstanceCount(), cluster.getQueryInstanceType(), cluster.getQueryInstanceCount(), UsageReportEvent.stripForUsageReport(cluster.getDataInstanceTiers()));
    }

    private static Map<Integer, InstanceTier> stripForUsageReport(Map<Integer, InstanceTier> instanceTierMap) {
        return instanceTierMap == null ? null : instanceTierMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> InstanceTier.stripForBillingReport((InstanceTier)x.getValue())));
    }
}

