/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.usage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.model.usage.UsageReportEvent;
import io.imply.cloud.model.usage.UsageReportInstanceTypeEntry;
import io.imply.cloud.model.usage.UsageReportIntervalEntry;
import io.imply.cloud.model.usage.UsageReportNodeEntry;
import io.imply.cloud.util.ToStringBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UsageReportClusterEntry {
    private final String clusterId;
    private final String clusterName;
    private final List<UsageReportIntervalEntry> intervals;
    private final List<UsageReportEvent> events;

    @JsonCreator
    public UsageReportClusterEntry(@JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="clusterName") String clusterName, @JsonProperty(value="intervals") List<UsageReportIntervalEntry> intervals, @JsonProperty(value="events") List<UsageReportEvent> events) {
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.intervals = intervals;
        this.events = events;
    }

    @JsonProperty
    public String getClusterId() {
        return this.clusterId;
    }

    @JsonProperty
    public String getClusterName() {
        return this.clusterName;
    }

    @JsonProperty
    public List<UsageReportIntervalEntry> getIntervals() {
        return this.intervals;
    }

    @JsonProperty
    public List<UsageReportEvent> getEvents() {
        return this.events;
    }

    @JsonProperty
    public Long getClusterMICU() {
        return this.intervals == null ? 0L : this.intervals.stream().mapToLong(UsageReportIntervalEntry::getIntervalMICU).sum();
    }

    @JsonProperty
    public List<UsageReportInstanceTypeEntry> getClusterInstanceUsage() {
        if (this.intervals == null) {
            return ImmutableList.of();
        }
        HashMap<String, Long> instanceUsage = new HashMap<String, Long>();
        for (UsageReportIntervalEntry intervalEntry : this.intervals) {
            for (UsageReportNodeEntry nodeEntry : intervalEntry.getNodes().values()) {
                instanceUsage.compute(nodeEntry.getType(), (k, v) -> this.accumulateInstanceSeconds((Long)v, nodeEntry.getCount(), intervalEntry.getIntervalSeconds()));
            }
        }
        return instanceUsage.entrySet().stream().map(x -> new UsageReportInstanceTypeEntry((String)x.getKey(), (Long)x.getValue())).collect(Collectors.toList());
    }

    private Long accumulateInstanceSeconds(Long previous, int instanceCount, long intervalSeconds) {
        long instanceSeconds = (long)instanceCount * intervalSeconds;
        return previous == null ? instanceSeconds : previous + instanceSeconds;
    }

    public String toString() {
        return new ToStringBuilder(this).append("clusterId", this.clusterId).append("clusterName", (Object)this.clusterName).append("intervals", this.intervals).append("events", this.events).toString();
    }
}

