/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.usage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.model.usage.UsageReportClusterEntry;
import io.imply.cloud.model.usage.UsageReportIntervalReport;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UsageReport {
    private final String accountId;
    private final DateTime timestamp;
    private final List<UsageReportClusterEntry> currentByCluster;
    private final UsageReportIntervalReport intervalReport;
    private final Long currentHourlyMICU;

    @JsonCreator
    public UsageReport(@JsonProperty(value="accountId") String accountId, @JsonProperty(value="timestamp") DateTime timestamp, @JsonProperty(value="currentByCluster") List<UsageReportClusterEntry> currentByCluster, @JsonProperty(value="intervalReport") UsageReportIntervalReport intervalReport) {
        this.accountId = accountId;
        this.timestamp = timestamp;
        this.currentByCluster = currentByCluster;
        this.intervalReport = intervalReport;
        this.currentHourlyMICU = currentByCluster == null ? 0L : currentByCluster.stream().mapToLong(UsageReportClusterEntry::getClusterMICU).sum();
    }

    @JsonProperty
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public Long getCurrentHourlyMICU() {
        return this.currentHourlyMICU;
    }

    @JsonProperty
    public List<UsageReportClusterEntry> getCurrentByCluster() {
        return this.currentByCluster;
    }

    @JsonProperty
    public UsageReportIntervalReport getIntervalReport() {
        return this.intervalReport;
    }

    public String toString() {
        return new ToStringBuilder(this).append("accountId", this.accountId).append("timestamp", (Object)this.timestamp).append("currentByCluster", this.currentByCluster).append("intervalReport", (Object)this.intervalReport).append("currentHourlyMICU", (Object)this.currentHourlyMICU).toString();
    }
}

