/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.metadatastorage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.imply.cloud.config.ConfigServerConfig;
import io.imply.cloud.model.metadatastorage.MetadataStorage;
import io.imply.cloud.model.metadatastorage.SqlMetadataStorage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PostgreSqlMetadataStorage
extends SqlMetadataStorage {
    private final ConfigServerConfig configServerConfig;

    @JsonCreator
    public PostgreSqlMetadataStorage(@JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="schema") String schema, @JsonProperty(value="user") String user, @JsonProperty(value="password") String password, @JsonProperty(value="tlsCert") String tlsCert, @JsonProperty(value="clientCert") String clientCert, @JsonProperty(value="clientKey") String clientKey, @JacksonInject ConfigServerConfig configServerConfig) {
        super(host, port, schema, user, password, tlsCert, clientCert, clientKey);
        this.configServerConfig = configServerConfig;
    }

    @Override
    protected MetadataStorage newInstance(String host, Integer port, String schema, String user, String password, String tlsCert, String clientCert, String clientKey) {
        return new PostgreSqlMetadataStorage(host, port, schema, user, password, tlsCert, clientCert, clientKey, this.configServerConfig);
    }

    @Override
    public String getMetadataType() {
        return "postgresql";
    }

    @Override
    public String getConnectionParameters() {
        if (Strings.isNullOrEmpty((String)this.getTlsCert())) {
            return null;
        }
        String clientCertParams = "";
        if (!Strings.isNullOrEmpty((String)this.getClientCert()) && !Strings.isNullOrEmpty((String)this.getClientKey())) {
            clientCertParams = String.format("&sslcert=%s/%s&sslkey=%s/%s", "/opt/imply/conf", "druid/_common/metadata-store-client-cert.pem", "/opt/imply/conf", "druid/_common/metadata-store-client-key.pk8");
        }
        return String.format("sslmode=%s&sslrootcert=%s/%s%s", this.configServerConfig != null && this.configServerConfig.getMetadataStoreSslMode() != null ? this.configServerConfig.getMetadataStoreSslMode() : "verify-ca", "/opt/imply/conf", "druid/_common/metadata-store.pem", clientCertParams);
    }
}

