/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.metadatastorage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.imply.cloud.config.ConfigServerConfig;
import io.imply.cloud.model.metadatastorage.MetadataStorage;
import io.imply.cloud.model.metadatastorage.SqlMetadataStorage;
import java.util.Optional;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class MySqlMetadataStorage
extends SqlMetadataStorage {
    protected final ConfigServerConfig configServerConfig;

    @JsonCreator
    public MySqlMetadataStorage(@JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="schema") String schema, @JsonProperty(value="user") String user, @JsonProperty(value="password") String password, @JsonProperty(value="tlsCert") String tlsCert, @JsonProperty(value="clientCert") String clientCert, @JsonProperty(value="clientKey") String clientKey, @JacksonInject ConfigServerConfig configServerConfig) {
        super(host, port, schema, user, password, tlsCert, clientCert, clientKey);
        this.configServerConfig = configServerConfig;
    }

    @Override
    protected MetadataStorage newInstance(String host, Integer port, String schema, String user, String password, String tlsCert, String clientCert, String clientKey) {
        return new MySqlMetadataStorage(host, port, schema, user, password, tlsCert, clientCert, clientKey, this.configServerConfig);
    }

    @Override
    public String getMetadataType() {
        return "mysql";
    }

    private String getMariaDBSslModeParams(String mySqlSslMode) {
        switch (mySqlSslMode) {
            case "DISABLED": 
            case "PREFERRED": {
                return "useSSL=false";
            }
            case "REQUIRED": {
                return "useSSL=true&trustServerCertificate=true&disableSslHostnameVerification=true";
            }
            case "VERIFY_CA": {
                return "useSSL=true&trustServerCertificate=false&disableSslHostnameVerification=true";
            }
            case "VERIFY_IDENTITY": {
                return "useSSL=true&trustServerCertificate=false&disableSslHostnameVerification=false";
            }
        }
        return "";
    }

    @Override
    public String getConnectionParameters() {
        if (Strings.isNullOrEmpty((String)this.getTlsCert())) {
            return "autoReconnect=true&allowPublicKeyRetrieval=true";
        }
        String clientCertParams = "";
        if (!Strings.isNullOrEmpty((String)this.getClientCert()) && !Strings.isNullOrEmpty((String)this.getClientKey())) {
            clientCertParams = String.format("&clientCertificateKeyStoreUrl=file://%s/%s&clientCertificateKeyStorePassword=%s", "/opt/imply/conf", "druid/_common/metadata-keystore.jks", "implymanager");
        }
        String sslMode = Optional.ofNullable(this.configServerConfig).map(cs -> cs.getMetadataStoreSslMode()).orElse("VERIFY_CA");
        return String.format("autoReconnect=true&allowPublicKeyRetrieval=true&sslMode=%s&requireSSL=true&%s&verifyServerCertificate=true&trustCertificateKeyStoreUrl=file://%s/%s&trustCertificateKeyStorePassword=%s%s", sslMode, this.getMariaDBSslModeParams(sslMode), "/opt/imply/conf", "druid/_common/metadata-truststore.jks", "implymanager", clientCertParams);
    }

    @Generated
    protected MySqlMetadataStorage(Builder<?, ?> b) {
        super(b);
        this.configServerConfig = b.configServerConfig;
    }

    @Generated
    public static Builder<?, ?> builder() {
        return new BuilderImpl();
    }

    @Generated
    public Builder<?, ?> toBuilder() {
        return new BuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public static abstract class Builder<C extends MySqlMetadataStorage, B extends Builder<C, B>>
    extends SqlMetadataStorage.Builder<C, B> {
        @Generated
        private ConfigServerConfig configServerConfig;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            Builder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MySqlMetadataStorage instance, Builder<?, ?> b) {
            b.configServerConfig(instance.configServerConfig);
        }

        @Generated
        public B configServerConfig(ConfigServerConfig configServerConfig) {
            this.configServerConfig = configServerConfig;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MySqlMetadataStorage.Builder(super=" + super.toString() + ", configServerConfig=" + String.valueOf(this.configServerConfig) + ")";
        }
    }

    @Generated
    private static final class BuilderImpl
    extends Builder<MySqlMetadataStorage, BuilderImpl> {
        @Generated
        private BuilderImpl() {
        }

        @Override
        @Generated
        protected BuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MySqlMetadataStorage build() {
            return new MySqlMetadataStorage(this);
        }
    }
}

