/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.metadatastorage;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.Mergeable;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.util.InstanceTypeHelper;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.Diffable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface MetadataStorage
extends Mergeable<MetadataStorage>,
Diffable<MetadataStorage> {
    public void validate(List<ImplyConstraintViolation> var1, RefreshableConstants var2);

    public MetadataStorage merge(MetadataStorage var1);

    @Override
    public MetadataStorage mergeDiff(MetadataStorage var1);

    public MetadataStorage filterNonNullFields(MetadataStorage var1);

    public MetadataStorage withDefaultsForUnset(boolean var1, InstanceTypeHelper var2);

    default public MetadataStorage withSensitiveFieldsMasked() {
        return this;
    }

    default public MetadataStorage withSensitiveFieldPlaceholdersRemoved() {
        return this;
    }

    default public MetadataStorage withSensitiveFieldPlaceholdersReplaced(DefaultsConfig defaultsConfig) {
        return this;
    }

    @Override
    public boolean isEmpty();

    public String getHost();

    public Integer getPort();

    public String getSchema();

    public String getUser();

    public String getPassword();

    public String getTlsCert();

    public String getClientCert();

    public String getClientKey();

    public String getConnectURI();

    public String getMetadataType();

    default public List<Set<UpdateDetails>> getSupportedUpdatesForDiff(Cluster previousCluster, boolean hasMultipleMasterNodes) {
        return this.isEmpty() ? ImmutableList.of() : MetadataStorage.getSupportedUpdates();
    }

    default public List<Set<UpdateDetails>> getSupportedUpdatesForDiff(Diff<MetadataStorage> diff, boolean hasMultipleMasterNodes) {
        return MetadataStorage.getSupportedUpdates();
    }

    public static List<Set<UpdateDetails>> getSupportedUpdates() {
        return ImmutableList.of((Object)ImmutableSet.of((Object)UpdateDetails.hard(10)));
    }
}

