/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.druid;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.Constants;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ReflectionDiffBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class S3DeepStorage
implements DeepStorage {
    private final String s3Location;
    private final Boolean useEncryption;
    private final String accessKey;
    private final String secretKey;

    @JsonCreator
    public S3DeepStorage(@JsonProperty(value="s3Location") String s3Location, @JsonProperty(value="useEncryption") Boolean useEncryption, @JsonProperty(value="accessKey") String accessKey, @JsonProperty(value="secretKey") String secretKey) {
        this.s3Location = s3Location;
        this.useEncryption = useEncryption;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    @JsonProperty
    public String getS3Location() {
        return this.s3Location;
    }

    @Override
    @JsonProperty
    public Boolean isUseEncryption() {
        return this.useEncryption;
    }

    @JsonProperty
    public String getAccessKey() {
        return this.accessKey;
    }

    @JsonProperty
    public String getSecretKey() {
        return this.secretKey;
    }

    public String getS3Bucket() {
        Matcher s3LocationMatcher = Constants.S3_LOCATION_PATTERN.matcher(this.s3Location);
        return s3LocationMatcher.matches() ? s3LocationMatcher.group(1) : null;
    }

    public String getS3Prefix() {
        Matcher s3LocationMatcher = Constants.S3_LOCATION_PATTERN.matcher(this.s3Location);
        return s3LocationMatcher.matches() ? s3LocationMatcher.group(2) : null;
    }

    @Override
    public void validate(List<ImplyConstraintViolation> results) {
        if (this.s3Location == null || !Constants.S3_LOCATION_PATTERN.matcher(this.s3Location).matches()) {
            results.add(ImplyConstraintViolation.error("deepStorage.s3Location", "[s3Location] must match regex: %s", Constants.S3_LOCATION_PATTERN.toString()));
        }
    }

    @Override
    public DeepStorage merge(DeepStorage other) {
        if (other == null) {
            return this;
        }
        if (!(other instanceof S3DeepStorage)) {
            return other;
        }
        S3DeepStorage s3Other = (S3DeepStorage)other;
        return new S3DeepStorage(s3Other.s3Location == null ? this.s3Location : s3Other.s3Location, s3Other.useEncryption == null ? this.useEncryption : s3Other.useEncryption, s3Other.accessKey == null ? this.accessKey : s3Other.accessKey, s3Other.secretKey == null ? this.secretKey : s3Other.secretKey);
    }

    @Override
    public DeepStorage mergeDiff(DeepStorage other) {
        if (other == null || !(other instanceof S3DeepStorage)) {
            return this;
        }
        S3DeepStorage s3Other = (S3DeepStorage)other;
        return new S3DeepStorage(this.s3Location == null ? null : (this.s3Location.equals(s3Other.s3Location) ? null : this.s3Location), this.useEncryption == null ? null : (this.useEncryption.equals(s3Other.useEncryption) ? null : this.useEncryption), this.accessKey == null ? null : (this.accessKey.equals(s3Other.accessKey) ? null : this.accessKey), this.secretKey == null ? null : (this.secretKey.equals(s3Other.secretKey) ? null : this.secretKey));
    }

    public DiffResult<DeepStorage> diff(DeepStorage other) {
        return new ReflectionDiffBuilder((Object)this, (Object)other, ToStringStyle.SHORT_PREFIX_STYLE).build();
    }

    @Override
    public DeepStorage filterNonNullFields(DeepStorage filter) {
        if (filter == null || !(filter instanceof S3DeepStorage)) {
            return new S3DeepStorage(null, null, null, null);
        }
        S3DeepStorage s3Filter = (S3DeepStorage)filter;
        return new S3DeepStorage(s3Filter.s3Location == null ? null : this.s3Location, s3Filter.useEncryption == null ? null : this.useEncryption, s3Filter.accessKey == null ? null : this.accessKey, s3Filter.secretKey == null ? null : this.secretKey);
    }

    @Override
    public DeepStorage withDefaultsForUnset(boolean setCreationOnlyDefaults) {
        if (!setCreationOnlyDefaults) {
            return this;
        }
        return new S3DeepStorage(this.s3Location, BooleanUtils.isNotFalse((Boolean)this.useEncryption), this.accessKey, this.secretKey);
    }

    @Override
    public boolean isEmpty() {
        return (this.s3Location == null || this.s3Location.isEmpty()) && this.useEncryption == null && this.accessKey == null && this.secretKey == null;
    }

    public int hashCode() {
        return Objects.hash(this.s3Location, this.useEncryption, this.accessKey, this.secretKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3DeepStorage that = (S3DeepStorage)o;
        return Objects.equals(this.s3Location, that.s3Location) && Objects.equals(this.useEncryption, that.useEncryption) && Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey);
    }

    @Override
    public Properties getSegmentLocationProperties() {
        Properties props = new Properties();
        props.setProperty("druid.storage.type", "s3");
        props.setProperty("druid.storage.bucket", this.getS3Bucket());
        props.setProperty("druid.storage.baseKey", this.getS3Prefix() == null ? "segments" : String.format("%s/%s", this.getS3Prefix(), "segments"));
        props.setProperty("druid.storage.disableAcl", "true");
        return this.maybeAddAwsCredentials(props);
    }

    @Override
    public Properties getIndexingLogLocationProperties() {
        Properties props = new Properties();
        props.setProperty("druid.indexer.logs.type", "s3");
        props.setProperty("druid.indexer.logs.s3Bucket", this.getS3Bucket());
        props.setProperty("druid.indexer.logs.s3Prefix", this.getS3Prefix() == null ? "indexing-logs" : String.format("%s/%s", this.getS3Prefix(), "indexing-logs"));
        return this.maybeAddAwsCredentials(props);
    }

    @Override
    public Properties getMSQEDurableStorageLocationProperties(@Nullable ImplyVersion implyVersion) {
        Properties props = new Properties();
        props.setProperty("druid.msq.intermediate.storage.enable", "true");
        props.setProperty("druid.msq.intermediate.storage.tempDir", "/mnt/tmp/msqe-durable-storage");
        props.setProperty("druid.msq.intermediate.storage.maxResultsSize", "10GiB");
        props.setProperty("druid.msq.intermediate.storage.cleaner.enabled", "true");
        props.setProperty("druid.msq.intermediate.storage.type", "s3");
        props.setProperty("druid.msq.intermediate.storage.bucket", this.getS3Bucket());
        props.setProperty("druid.msq.intermediate.storage.prefix", this.getS3Prefix() == null ? "msqe-durable-storage" : String.format("%s/%s", this.getS3Prefix(), "msqe-durable-storage"));
        return props;
    }

    @Override
    public DeepStorage withSensitiveFieldsMasked() {
        return new S3DeepStorage(this.s3Location, this.useEncryption, this.accessKey, this.secretKey != null ? "{secret}" : null);
    }

    @Override
    public DeepStorage withSensitiveFieldPlaceholdersRemoved() {
        return new S3DeepStorage(this.s3Location, this.useEncryption, this.accessKey, "{secret}".equals(this.secretKey) ? null : this.secretKey);
    }

    @Override
    public DeepStorage withSensitiveFieldPlaceholdersReplaced(DefaultsConfig defaultsConfig) {
        if ("{secret}".equals(this.secretKey) && this.accessKey != null && this.accessKey.equals(defaultsConfig.getDeepStorageUser())) {
            return new S3DeepStorage(this.s3Location, this.useEncryption, this.accessKey, defaultsConfig.getDeepStoragePassword());
        }
        return this;
    }

    public String toString() {
        return new ToStringBuilder(this).append("s3Location", this.s3Location).append("useEncryption", (Object)this.useEncryption).append("accessKey", (Object)this.accessKey).append("secretKey", (Object)"*****************").toString();
    }

    private Properties maybeAddAwsCredentials(Properties props) {
        if (props == null || this.accessKey == null || this.secretKey == null || this.accessKey.isEmpty() || this.secretKey.isEmpty()) {
            return props;
        }
        props.setProperty("druid.s3.accessKey", this.accessKey);
        props.setProperty("druid.s3.secretKey", this.secretKey);
        return props;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().s3Location(this.s3Location).useEncryption(this.useEncryption).accessKey(this.accessKey).secretKey(this.secretKey);
    }

    @Generated
    public static class Builder {
        @Generated
        private String s3Location;
        @Generated
        private Boolean useEncryption;
        @Generated
        private String accessKey;
        @Generated
        private String secretKey;

        @Generated
        Builder() {
        }

        @Generated
        public Builder s3Location(String s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        @Generated
        public Builder useEncryption(Boolean useEncryption) {
            this.useEncryption = useEncryption;
            return this;
        }

        @Generated
        public Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        @Generated
        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Generated
        public S3DeepStorage build() {
            return new S3DeepStorage(this.s3Location, this.useEncryption, this.accessKey, this.secretKey);
        }

        @Generated
        public String toString() {
            return "S3DeepStorage.Builder(s3Location=" + this.s3Location + ", useEncryption=" + this.useEncryption + ", accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ")";
        }
    }
}

