/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.druid;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.util.StringUtils;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ReflectionDiffBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class HdfsDeepStorage
implements DeepStorage {
    private final String storageDirectory;

    @JsonCreator
    public HdfsDeepStorage(@JsonProperty(value="storageDirectory") String storageDirectory) {
        this.storageDirectory = StringUtils.stripTrailingSlashes(storageDirectory);
    }

    @JsonProperty
    public String getStorageDirectory() {
        return this.storageDirectory;
    }

    @Override
    public void validate(List<ImplyConstraintViolation> results) {
        if (this.storageDirectory == null || !this.storageDirectory.startsWith("hdfs://")) {
            results.add(ImplyConstraintViolation.error("deepStorage.storageDirectory", "[storageDirectory] must start with 'hdfs://'", new Object[0]));
        }
    }

    @Override
    public DeepStorage merge(DeepStorage other) {
        if (other == null) {
            return this;
        }
        if (!(other instanceof HdfsDeepStorage)) {
            return other;
        }
        HdfsDeepStorage localOther = (HdfsDeepStorage)other;
        return new HdfsDeepStorage(localOther.storageDirectory == null ? this.storageDirectory : localOther.storageDirectory);
    }

    @Override
    public DeepStorage mergeDiff(DeepStorage other) {
        if (other == null || !(other instanceof HdfsDeepStorage)) {
            return this;
        }
        HdfsDeepStorage localOther = (HdfsDeepStorage)other;
        return new HdfsDeepStorage(this.storageDirectory == null ? null : (this.storageDirectory.equals(localOther.storageDirectory) ? null : this.storageDirectory));
    }

    public DiffResult<DeepStorage> diff(DeepStorage other) {
        return new ReflectionDiffBuilder((Object)this, (Object)other, ToStringStyle.SHORT_PREFIX_STYLE).build();
    }

    @Override
    public DeepStorage filterNonNullFields(DeepStorage filter) {
        if (filter == null || !(filter instanceof HdfsDeepStorage)) {
            return new HdfsDeepStorage(null);
        }
        HdfsDeepStorage localFilter = (HdfsDeepStorage)filter;
        return new HdfsDeepStorage(localFilter.getStorageDirectory() == null ? null : this.storageDirectory);
    }

    @Override
    public boolean isEmpty() {
        return this.storageDirectory == null;
    }

    @Override
    public Properties getSegmentLocationProperties() {
        Properties props = new Properties();
        props.setProperty("druid.storage.type", "hdfs");
        props.setProperty("druid.storage.storageDirectory", String.format("%s/segments", this.storageDirectory));
        return props;
    }

    @Override
    public Properties getIndexingLogLocationProperties() {
        Properties props = new Properties();
        props.setProperty("druid.indexer.logs.type", "hdfs");
        props.setProperty("druid.indexer.logs.directory", String.format("%s/indexing-logs", this.storageDirectory));
        return props;
    }

    public String toString() {
        return new ToStringBuilder(this).append("storageDirectory", this.storageDirectory).toString();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().storageDirectory(this.storageDirectory);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HdfsDeepStorage)) {
            return false;
        }
        HdfsDeepStorage other = (HdfsDeepStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$storageDirectory = this.getStorageDirectory();
        String other$storageDirectory = other.getStorageDirectory();
        return !(this$storageDirectory == null ? other$storageDirectory != null : !this$storageDirectory.equals(other$storageDirectory));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HdfsDeepStorage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $storageDirectory = this.getStorageDirectory();
        result = result * 59 + ($storageDirectory == null ? 43 : $storageDirectory.hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private String storageDirectory;

        @Generated
        Builder() {
        }

        @Generated
        public Builder storageDirectory(String storageDirectory) {
            this.storageDirectory = storageDirectory;
            return this;
        }

        @Generated
        public HdfsDeepStorage build() {
            return new HdfsDeepStorage(this.storageDirectory);
        }

        @Generated
        public String toString() {
            return "HdfsDeepStorage.Builder(storageDirectory=" + this.storageDirectory + ")";
        }
    }
}

