/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.druid;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import io.imply.cloud.Constants;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ReflectionDiffBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AzureDeepStorage
implements DeepStorage {
    @VisibleForTesting
    static final String AZURE = "azure";
    @VisibleForTesting
    static final String AZURE_ACCOUNT = "druid.azure.account";
    @VisibleForTesting
    static final String AZURE_SEGMENTS_CONTAINER = "druid.azure.container";
    @VisibleForTesting
    static final String AZURE_SEGMENTS_PREFIX = "druid.azure.prefix";
    @VisibleForTesting
    static final String AZURE_INDEXER_LOGS_CONTAINER = "druid.indexer.logs.container";
    @VisibleForTesting
    static final String AZURE_SECRET_ACCESS_KEY = "druid.azure.key";
    @VisibleForTesting
    static final String AZURE_CREDENTIALS_CHAIN = "druid.azure.useAzureCredentialsChain";
    private final String azureAccount;
    private final String azureKey;
    private final String azureLocation;
    private final Boolean useAzureCredentialsChain;
    private final String azureDnsZone;

    @JsonCreator
    public AzureDeepStorage(@JsonProperty(value="azureAccount") String azureAccount, @JsonProperty(value="azureKey") String azureKey, @JsonProperty(value="azureLocation") String azureLocation, @JsonProperty(value="useAzureCredentialsChain") Boolean useAzureCredentialsChain, @JsonProperty(value="azureDnsZone") String azureDnsZone) {
        this.azureAccount = azureAccount;
        this.azureKey = azureKey;
        this.azureLocation = azureLocation;
        this.useAzureCredentialsChain = useAzureCredentialsChain;
        this.azureDnsZone = azureDnsZone;
    }

    @JsonProperty
    public String getAzureAccount() {
        return this.azureAccount;
    }

    @JsonProperty
    public String getAzureKey() {
        return this.azureKey;
    }

    @JsonProperty
    public String getAzureLocation() {
        return this.azureLocation;
    }

    @JsonProperty
    public Boolean getUseAzureCredentialsChain() {
        return this.useAzureCredentialsChain;
    }

    @JsonProperty
    public String getAzureDnsZone() {
        return this.azureDnsZone;
    }

    public String getAzureContainer() {
        if (this.azureLocation == null) {
            return null;
        }
        Matcher azureLocationMatcher = Constants.AZURE_LOCATION_PATTERN.matcher(this.azureLocation);
        return azureLocationMatcher.matches() ? azureLocationMatcher.group(1) : null;
    }

    public String getAzurePrefix() {
        if (this.azureLocation == null) {
            return null;
        }
        Matcher azureLocationMatcher = Constants.AZURE_LOCATION_PATTERN.matcher(this.azureLocation);
        return azureLocationMatcher.matches() ? azureLocationMatcher.group(2) : null;
    }

    @Override
    public void validate(List<ImplyConstraintViolation> results) {
        if (this.azureAccount == null) {
            results.add(ImplyConstraintViolation.error("deepStorage.azureAccount", "[azureAccount] must not be null", new Object[0]));
        }
        if (BooleanUtils.isTrue((Boolean)this.useAzureCredentialsChain) && StringUtils.isNotBlank((CharSequence)this.azureKey)) {
            results.add(ImplyConstraintViolation.error("deepStorage.azureKey", "[azureKey] must not be set when [useAzureCredentialsChain] is true", new Object[0]));
        }
        if (BooleanUtils.isFalse((Boolean)this.useAzureCredentialsChain) && (this.azureKey == null || !Base64.isBase64((String)this.azureKey) && !"{secret}".equals(this.azureKey))) {
            results.add(ImplyConstraintViolation.error("deepStorage.azureKey", "[azureKey] must be base64 encoded", new Object[0]));
        }
        if (this.azureLocation == null || !Constants.AZURE_LOCATION_PATTERN.matcher(this.azureLocation).matches()) {
            results.add(ImplyConstraintViolation.error("deepStorage.azureLocation", "[azureLocation] must match regex: %s", Constants.AZURE_LOCATION_PATTERN.toString()));
        }
        if (this.azureDnsZone != null && !Constants.AZURE_DNS_ZONE_PATTERN.matcher(this.azureDnsZone).matches()) {
            results.add(ImplyConstraintViolation.error("deepStorage.azureDnsZone", "[azureDnsZone] must match regex: %s", Constants.AZURE_DNS_ZONE_PATTERN.toString()));
        }
    }

    @Override
    public DeepStorage merge(DeepStorage other) {
        if (other == null) {
            return this;
        }
        if (!(other instanceof AzureDeepStorage)) {
            return other;
        }
        AzureDeepStorage azureOther = (AzureDeepStorage)other;
        return new AzureDeepStorage(azureOther.azureAccount == null ? this.azureAccount : azureOther.azureAccount, azureOther.azureKey == null ? this.azureKey : azureOther.azureKey, azureOther.azureLocation == null ? this.azureLocation : azureOther.azureLocation, azureOther.useAzureCredentialsChain == null ? this.useAzureCredentialsChain : azureOther.useAzureCredentialsChain, azureOther.azureDnsZone == null ? this.azureDnsZone : azureOther.azureDnsZone);
    }

    @Override
    public DeepStorage mergeDiff(DeepStorage other) {
        if (other == null || !(other instanceof AzureDeepStorage)) {
            return this;
        }
        AzureDeepStorage azureOther = (AzureDeepStorage)other;
        return new AzureDeepStorage(this.azureAccount == null ? null : (this.azureAccount.equals(azureOther.azureAccount) ? null : this.azureAccount), this.azureKey == null ? null : (this.azureKey.equals(azureOther.azureKey) ? null : this.azureKey), this.azureLocation == null ? null : (this.azureLocation.equals(azureOther.azureLocation) ? null : this.azureLocation), this.useAzureCredentialsChain == null ? null : (this.useAzureCredentialsChain.equals(azureOther.useAzureCredentialsChain) ? null : this.useAzureCredentialsChain), this.azureDnsZone == null ? null : (this.azureDnsZone.equals(azureOther.azureDnsZone) ? null : this.azureDnsZone));
    }

    public DiffResult<DeepStorage> diff(DeepStorage other) {
        return new ReflectionDiffBuilder((Object)this, (Object)other, ToStringStyle.SHORT_PREFIX_STYLE).build();
    }

    @Override
    public DeepStorage filterNonNullFields(DeepStorage filter) {
        if (filter == null || !(filter instanceof AzureDeepStorage)) {
            return new AzureDeepStorage(null, null, null, null, null);
        }
        AzureDeepStorage azureFilter = (AzureDeepStorage)filter;
        return new AzureDeepStorage(azureFilter.azureAccount == null ? null : this.azureAccount, azureFilter.azureKey == null ? null : this.azureKey, azureFilter.azureLocation == null ? null : this.azureLocation, azureFilter.useAzureCredentialsChain == null ? null : this.useAzureCredentialsChain, azureFilter.azureDnsZone == null ? null : this.azureDnsZone);
    }

    @Override
    public boolean isEmpty() {
        return !(this.azureAccount != null && !this.azureAccount.isEmpty() || this.azureKey != null && !this.azureKey.isEmpty() || this.azureLocation != null && !this.azureLocation.isEmpty() || this.useAzureCredentialsChain != null || this.azureDnsZone != null && !this.azureDnsZone.isEmpty());
    }

    public int hashCode() {
        return Objects.hash(this.azureAccount, this.azureKey, this.azureLocation, this.useAzureCredentialsChain);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureDeepStorage that = (AzureDeepStorage)o;
        return Objects.equals(this.azureAccount, that.azureAccount) && Objects.equals(this.azureKey, that.azureKey) && Objects.equals(this.azureLocation, that.azureLocation) && Objects.equals(this.useAzureCredentialsChain, that.useAzureCredentialsChain) && Objects.equals(this.azureDnsZone, that.azureDnsZone);
    }

    @Override
    public Properties getSegmentLocationProperties() {
        Properties props = new Properties();
        String azurePrefix = this.getAzurePrefix();
        props.setProperty("druid.storage.type", AZURE);
        props.setProperty(AZURE_ACCOUNT, this.azureAccount);
        if (BooleanUtils.isTrue((Boolean)this.useAzureCredentialsChain)) {
            props.setProperty(AZURE_CREDENTIALS_CHAIN, "true");
        } else {
            props.setProperty(AZURE_SECRET_ACCESS_KEY, this.azureKey);
        }
        props.setProperty(AZURE_SEGMENTS_CONTAINER, this.getAzureContainer());
        props.setProperty(AZURE_SEGMENTS_PREFIX, azurePrefix == null ? "segments" : String.format("%s/%s", azurePrefix, "segments"));
        return props;
    }

    @Override
    public Properties getIndexingLogLocationProperties() {
        Properties props = new Properties();
        String azurePrefix = this.getAzurePrefix();
        props.setProperty("druid.indexer.logs.type", AZURE);
        props.setProperty(AZURE_INDEXER_LOGS_CONTAINER, this.getAzureContainer());
        props.setProperty("druid.indexer.logs.prefix", azurePrefix == null ? "indexing-logs" : String.format("%s/%s", azurePrefix, "indexing-logs"));
        return props;
    }

    @Override
    public Properties getMSQEDurableStorageLocationProperties(@Nullable ImplyVersion implyVersion) {
        Properties props = new Properties();
        if (implyVersion == null || implyVersion.getComparableVersion() == null || implyVersion.getComparableVersion().compareTo(new ComparableVersion("2023.09")) < 0) {
            return props;
        }
        props.setProperty("druid.msq.intermediate.storage.enable", "true");
        props.setProperty("druid.msq.intermediate.storage.tempDir", "/mnt/tmp/msqe-durable-storage");
        props.setProperty("druid.msq.intermediate.storage.maxResultsSize", "10GiB");
        props.setProperty("druid.msq.intermediate.storage.cleaner.enabled", "true");
        props.setProperty("druid.msq.intermediate.storage.type", AZURE);
        props.setProperty("druid.msq.intermediate.storage.container", this.getAzureContainer());
        props.setProperty("druid.msq.intermediate.storage.prefix", this.getAzurePrefix() == null ? "msqe-durable-storage" : String.format("%s/%s", this.getAzurePrefix(), "msqe-durable-storage"));
        return props;
    }

    @Override
    public DeepStorage withSensitiveFieldsMasked() {
        return new AzureDeepStorage(this.azureAccount, this.azureKey != null ? "{secret}" : null, this.azureLocation, this.useAzureCredentialsChain, this.azureDnsZone);
    }

    @Override
    public DeepStorage withSensitiveFieldPlaceholdersRemoved() {
        return new AzureDeepStorage(this.azureAccount, "{secret}".equals(this.azureKey) ? null : this.azureKey, this.azureLocation, this.useAzureCredentialsChain, this.azureDnsZone);
    }

    @Override
    public DeepStorage withSensitiveFieldPlaceholdersReplaced(DefaultsConfig defaultsConfig) {
        if ("{secret}".equals(this.azureKey)) {
            return new AzureDeepStorage(this.azureAccount, defaultsConfig.getDeepStoragePassword(), this.azureLocation, this.useAzureCredentialsChain, this.azureDnsZone);
        }
        return this;
    }

    public String toString() {
        return new ToStringBuilder(this).append("azureAccount", this.azureAccount).append("azureKey", (Object)"*****************").append("azureLocation", (Object)this.azureLocation).append("useAzureCredentialsChain", (Object)this.useAzureCredentialsChain).append("azureDnsZone", (Object)this.azureDnsZone).toString();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().azureAccount(this.azureAccount).azureKey(this.azureKey).azureLocation(this.azureLocation).useAzureCredentialsChain(this.useAzureCredentialsChain).azureDnsZone(this.azureDnsZone);
    }

    @Generated
    public static class Builder {
        @Generated
        private String azureAccount;
        @Generated
        private String azureKey;
        @Generated
        private String azureLocation;
        @Generated
        private Boolean useAzureCredentialsChain;
        @Generated
        private String azureDnsZone;

        @Generated
        Builder() {
        }

        @Generated
        public Builder azureAccount(String azureAccount) {
            this.azureAccount = azureAccount;
            return this;
        }

        @Generated
        public Builder azureKey(String azureKey) {
            this.azureKey = azureKey;
            return this;
        }

        @Generated
        public Builder azureLocation(String azureLocation) {
            this.azureLocation = azureLocation;
            return this;
        }

        @Generated
        public Builder useAzureCredentialsChain(Boolean useAzureCredentialsChain) {
            this.useAzureCredentialsChain = useAzureCredentialsChain;
            return this;
        }

        @Generated
        public Builder azureDnsZone(String azureDnsZone) {
            this.azureDnsZone = azureDnsZone;
            return this;
        }

        @Generated
        public AzureDeepStorage build() {
            return new AzureDeepStorage(this.azureAccount, this.azureKey, this.azureLocation, this.useAzureCredentialsChain, this.azureDnsZone);
        }

        @Generated
        public String toString() {
            return "AzureDeepStorage.Builder(azureAccount=" + this.azureAccount + ", azureKey=" + this.azureKey + ", azureLocation=" + this.azureLocation + ", useAzureCredentialsChain=" + this.useAzureCredentialsChain + ", azureDnsZone=" + this.azureDnsZone + ")";
        }
    }
}

