/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Objects;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserFile {
    private final String path;
    private final Boolean classpath;
    private final Boolean unpack;
    private final Boolean executable;
    private final Boolean hadoopDependency;
    private final Boolean druidExtension;
    private final String metadata;

    @JsonCreator
    public UserFile(@JsonProperty(value="path") String path, @JsonProperty(value="classpath") Boolean classpath, @JsonProperty(value="unpack") Boolean unpack, @JsonProperty(value="executable") Boolean executable, @JsonProperty(value="hadoopDependency") Boolean hadoopDependency, @JsonProperty(value="druidExtension") Boolean druidExtension, @JsonProperty(value="metadata") String metadata) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.classpath = classpath;
        this.unpack = unpack;
        this.executable = executable;
        this.hadoopDependency = hadoopDependency;
        this.druidExtension = druidExtension;
        this.metadata = metadata;
    }

    public UserFile(String path) {
        this(path, null, null, null, null, null, null);
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public Boolean isClasspath() {
        return this.classpath;
    }

    @JsonProperty
    public Boolean isUnpack() {
        return this.unpack;
    }

    @JsonProperty
    public Boolean isExecutable() {
        return this.executable;
    }

    @JsonProperty
    public Boolean isHadoopDependency() {
        return this.hadoopDependency;
    }

    @JsonProperty
    public Boolean isDruidExtension() {
        return this.druidExtension;
    }

    @JsonProperty
    public String getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return new ToStringBuilder(this).append("path", this.path).append("classpath", (Object)this.classpath).append("unpack", (Object)this.unpack).append("executable", (Object)this.executable).append("hadoopDependency", (Object)this.hadoopDependency).append("druidExtension", (Object)this.druidExtension).append("metadata", (Object)this.metadata).toString();
    }

    public boolean equals(Object o) {
        return this.equalsExcludingMetadata(o) && Objects.equals(this.metadata, ((UserFile)o).metadata);
    }

    public boolean equalsExcludingMetadata(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFile userFile = (UserFile)o;
        return Objects.equals(this.path, userFile.path) && Objects.equals(this.classpath, userFile.classpath) && Objects.equals(this.unpack, userFile.unpack) && Objects.equals(this.executable, userFile.executable) && Objects.equals(this.hadoopDependency, userFile.hadoopDependency) && Objects.equals(this.druidExtension, userFile.druidExtension);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.classpath, this.unpack, this.executable, this.hadoopDependency, this.druidExtension, this.metadata);
    }

    public UserFile withDefaultsForUnset() {
        Builder builder = this.toBuilder();
        if (this.druidExtension == null) {
            builder.druidExtension(false);
        }
        if (this.hadoopDependency == null) {
            builder.hadoopDependency(false);
        }
        if (this.classpath == null) {
            builder.classpath(false);
        }
        return builder.build();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().path(this.path).classpath(this.classpath).unpack(this.unpack).executable(this.executable).hadoopDependency(this.hadoopDependency).druidExtension(this.druidExtension).metadata(this.metadata);
    }

    @Generated
    public static class Builder {
        @Generated
        private String path;
        @Generated
        private Boolean classpath;
        @Generated
        private Boolean unpack;
        @Generated
        private Boolean executable;
        @Generated
        private Boolean hadoopDependency;
        @Generated
        private Boolean druidExtension;
        @Generated
        private String metadata;

        @Generated
        Builder() {
        }

        @Generated
        public Builder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public Builder classpath(Boolean classpath) {
            this.classpath = classpath;
            return this;
        }

        @Generated
        public Builder unpack(Boolean unpack) {
            this.unpack = unpack;
            return this;
        }

        @Generated
        public Builder executable(Boolean executable) {
            this.executable = executable;
            return this;
        }

        @Generated
        public Builder hadoopDependency(Boolean hadoopDependency) {
            this.hadoopDependency = hadoopDependency;
            return this;
        }

        @Generated
        public Builder druidExtension(Boolean druidExtension) {
            this.druidExtension = druidExtension;
            return this;
        }

        @Generated
        public Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public UserFile build() {
            return new UserFile(this.path, this.classpath, this.unpack, this.executable, this.hadoopDependency, this.druidExtension, this.metadata);
        }

        @Generated
        public String toString() {
            return "UserFile.Builder(path=" + this.path + ", classpath=" + this.classpath + ", unpack=" + this.unpack + ", executable=" + this.executable + ", hadoopDependency=" + this.hadoopDependency + ", druidExtension=" + this.druidExtension + ", metadata=" + this.metadata + ")";
        }
    }
}

