/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.util.ToStringBuilder;
import java.security.Principal;
import java.util.List;
import lombok.Generated;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class User
implements Principal {
    protected final String userId;
    protected final String accountId;
    protected final Integer version;
    protected final DateTime created;
    protected final DateTime lastModified;
    protected final List<String> accountIds;

    @JsonCreator
    public User(@JsonProperty(value="userId") String userId, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="version") Integer version, @JsonProperty(value="created") DateTime created, @JsonProperty(value="lastModified") DateTime lastModified, @JsonProperty(value="accountIds") List<String> accountIds) {
        this.userId = userId;
        this.accountId = accountId;
        this.version = version;
        this.created = created;
        this.lastModified = lastModified;
        this.accountIds = accountIds;
    }

    @JsonProperty
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getName() {
        return this.userId;
    }

    public String getDetailedUserId() {
        return this.userId;
    }

    @JsonProperty
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty
    public DateTime getCreated() {
        return this.created;
    }

    @JsonProperty
    public DateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty
    public List<String> getAccountIds() {
        ImmutableList.Builder accounts = ImmutableList.builder();
        if (this.accountIds != null) {
            accounts.addAll(this.accountIds);
        }
        if (!(this.accountId == null || this.accountIds != null && this.accountIds.contains(this.accountId))) {
            accounts.add((Object)this.accountId);
        }
        return accounts.build();
    }

    public User withVersion(Integer version) {
        return new User(this.userId, this.accountId, version, this.created, this.lastModified, this.accountIds);
    }

    public User withUserId(String userId) {
        return new User(userId, this.accountId, this.version, this.created, this.lastModified, this.accountIds);
    }

    public User withCreated(DateTime created) {
        return new User(this.userId, this.accountId, this.version, created, this.lastModified, this.accountIds);
    }

    public User withLastModified(DateTime lastModified) {
        return new User(this.userId, this.accountId, this.version, this.created, lastModified, this.accountIds);
    }

    public User merge(User partialRecord) {
        String userId = partialRecord.userId != null ? partialRecord.userId : this.userId;
        String accountId = partialRecord.accountId != null ? partialRecord.accountId : this.accountId;
        Integer version = partialRecord.version != null ? partialRecord.version : this.version;
        DateTime created = partialRecord.created != null ? partialRecord.created : this.created;
        DateTime lastModified = partialRecord.lastModified != null ? partialRecord.lastModified : this.lastModified;
        List<String> accountIds = partialRecord.accountIds != null ? partialRecord.accountIds : this.accountIds;
        return new User(userId, accountId, version, created, lastModified, accountIds);
    }

    public void validate(boolean skipUserId) {
        if (!skipUserId) {
            Preconditions.checkArgument((this.userId != null ? 1 : 0) != 0, (Object)"[userId] required");
        }
        Preconditions.checkArgument((!this.getAccountIds().isEmpty() ? 1 : 0) != 0, (Object)"[accountId] or [accountIds] required");
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("userId", this.userId).append("accountId", (Object)this.accountId).append("version", (Object)this.version).append("created", (Object)this.created).append("lastModified", (Object)this.lastModified).append("accountIds", this.accountIds).toString();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public static class Builder {
        @Generated
        private String userId;
        @Generated
        private String accountId;
        @Generated
        private Integer version;
        @Generated
        private DateTime created;
        @Generated
        private DateTime lastModified;
        @Generated
        private List<String> accountIds;

        @Generated
        Builder() {
        }

        @Generated
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Generated
        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        @Generated
        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        @Generated
        public Builder lastModified(DateTime lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Generated
        public Builder accountIds(List<String> accountIds) {
            this.accountIds = accountIds;
            return this;
        }

        @Generated
        public User build() {
            return new User(this.userId, this.accountId, this.version, this.created, this.lastModified, this.accountIds);
        }

        @Generated
        public String toString() {
            return "User.Builder(userId=" + this.userId + ", accountId=" + this.accountId + ", version=" + this.version + ", created=" + String.valueOf(this.created) + ", lastModified=" + String.valueOf(this.lastModified) + ", accountIds=" + String.valueOf(this.accountIds) + ")";
        }
    }
}

