/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.Constants;
import io.imply.cloud.model.Host;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.util.ToStringBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UpdateState {
    @JsonProperty
    private final UpdateType type;
    @JsonProperty
    private final List<UpdateType> supportedTypes;
    @JsonProperty
    private final Deque<Stage> pendingRollingStages;
    @JsonProperty
    private final Deque<Stage> completedRollingStages;
    @JsonProperty
    private final DateTime rollingStageStartTime;
    @JsonProperty
    private final Integer rollingStageConsecutiveExceptions;
    @JsonProperty
    private final Integer rollingStageExecutionCount;
    @JsonProperty
    private final String coordinatorDynamicConfiguration;
    @JsonProperty
    private final List<Host> preUpdateHosts;
    @JsonProperty
    private final State currentState;
    @JsonProperty
    private final Integer rollbackAttemptCount;
    @JsonProperty
    private final Map<String, Object> originalParameters;
    @JsonProperty
    private final Map<String, Object> modifiedParameters;
    @JsonProperty
    private final Boolean waitingForRetryOrRollback;
    @JsonProperty
    private final Boolean cancelAllowed;
    @JsonProperty
    private final Boolean performingRollback;
    @JsonProperty
    private final Boolean switchToHardUpdateAllowed;
    @JsonProperty
    private final UpdatePhase phase;
    @JsonProperty
    private final List<String> hosts;
    @JsonProperty
    private final String rdsInstanceId;

    @JsonProperty
    public Integer getCurrentStageNumber() {
        return Math.min(this.getTotalStageCount(), this.completedRollingStages == null ? 1 : this.completedRollingStages.size() + 1);
    }

    @JsonProperty
    public Integer getTotalStageCount() {
        return (this.pendingRollingStages == null ? 0 : this.pendingRollingStages.size()) + (this.completedRollingStages == null ? 0 : this.completedRollingStages.size());
    }

    @JsonProperty
    public Stage getCurrentStage() {
        return this.pendingRollingStages == null ? null : this.pendingRollingStages.peekFirst();
    }

    public UpdateState merge(UpdateState partialRecord) {
        if (partialRecord == null) {
            return this;
        }
        return new UpdateState((UpdateType)((Object)ObjectUtils.defaultIfNull((Object)((Object)partialRecord.type), (Object)((Object)this.type))), (List)ObjectUtils.defaultIfNull(partialRecord.supportedTypes, this.supportedTypes), (Deque)ObjectUtils.defaultIfNull(partialRecord.pendingRollingStages, this.pendingRollingStages), (Deque)ObjectUtils.defaultIfNull(partialRecord.completedRollingStages, this.completedRollingStages), (DateTime)ObjectUtils.defaultIfNull((Object)partialRecord.rollingStageStartTime, (Object)this.rollingStageStartTime), (Integer)ObjectUtils.defaultIfNull((Object)partialRecord.rollingStageConsecutiveExceptions, (Object)this.rollingStageConsecutiveExceptions), (Integer)ObjectUtils.defaultIfNull((Object)partialRecord.rollingStageExecutionCount, (Object)this.rollingStageExecutionCount), (String)ObjectUtils.defaultIfNull((Object)partialRecord.coordinatorDynamicConfiguration, (Object)this.coordinatorDynamicConfiguration), (List)ObjectUtils.defaultIfNull(partialRecord.preUpdateHosts, this.preUpdateHosts), (State)((Object)ObjectUtils.defaultIfNull((Object)((Object)partialRecord.currentState), (Object)((Object)this.currentState))), (Integer)ObjectUtils.defaultIfNull((Object)partialRecord.rollbackAttemptCount, (Object)this.rollbackAttemptCount), (Map)ObjectUtils.defaultIfNull(partialRecord.originalParameters, this.originalParameters), (Map)ObjectUtils.defaultIfNull(partialRecord.modifiedParameters, this.modifiedParameters), (Boolean)ObjectUtils.defaultIfNull((Object)partialRecord.waitingForRetryOrRollback, (Object)this.waitingForRetryOrRollback), (Boolean)ObjectUtils.defaultIfNull((Object)partialRecord.cancelAllowed, (Object)this.cancelAllowed), (Boolean)ObjectUtils.defaultIfNull((Object)partialRecord.performingRollback, (Object)this.performingRollback), (Boolean)ObjectUtils.defaultIfNull((Object)partialRecord.switchToHardUpdateAllowed, (Object)this.switchToHardUpdateAllowed), (UpdatePhase)((Object)ObjectUtils.defaultIfNull((Object)((Object)partialRecord.phase), (Object)((Object)this.phase))), (List)ObjectUtils.defaultIfNull(partialRecord.hosts, this.hosts), (String)ObjectUtils.defaultIfNull((Object)partialRecord.rdsInstanceId, (Object)this.rdsInstanceId));
    }

    public UpdateState removeClearedFields() {
        Builder builder = this.toBuilder();
        builder.type(UpdateType.NOT_SET.equals((Object)this.type) ? null : this.type);
        builder.rollingStageStartTime(Constants.CLEAR_FIELD_DATETIME.equals((Object)this.rollingStageStartTime) ? null : this.rollingStageStartTime);
        builder.rollingStageConsecutiveExceptions(Constants.CLEAR_FIELD_INT.equals(this.rollingStageConsecutiveExceptions) ? null : this.rollingStageConsecutiveExceptions);
        builder.rollingStageExecutionCount(Constants.CLEAR_FIELD_INT.equals(this.rollingStageExecutionCount) ? null : this.rollingStageExecutionCount);
        builder.coordinatorDynamicConfiguration("".equals(this.coordinatorDynamicConfiguration) ? null : this.coordinatorDynamicConfiguration);
        builder.currentState(State.CLEAR_FIELD.equals((Object)this.currentState) ? null : this.currentState);
        builder.rollbackAttemptCount(Constants.CLEAR_FIELD_INT.equals(this.rollbackAttemptCount) ? null : this.rollbackAttemptCount);
        builder.phase(UpdatePhase.NOT_SET.equals((Object)this.phase) ? null : this.phase);
        builder.rdsInstanceId("".equals(this.rdsInstanceId) ? null : this.rdsInstanceId);
        return builder.build();
    }

    public UpdateState stripInternalFields() {
        return this.toBuilder().rollingStageConsecutiveExceptions(null).coordinatorDynamicConfiguration(null).preUpdateHosts(null).currentState(null).rollbackAttemptCount(null).pendingRollingStages(this.generateSimplifiedStages(this.pendingRollingStages)).completedRollingStages(this.generateSimplifiedStages(this.completedRollingStages)).build();
    }

    private Deque<Stage> generateSimplifiedStages(Deque<Stage> stages) {
        if (stages == null) {
            return null;
        }
        return stages.stream().map(Stage::stripInternalFields).collect(Collectors.toCollection(ArrayDeque::new));
    }

    public String toString() {
        return new ToStringBuilder(this).append("cancelAllowed", this.cancelAllowed).append("completedRollingStages", this.completedRollingStages).append("coordinatorDynamicConfiguration", (Object)this.coordinatorDynamicConfiguration).append("currentState", (Object)this.currentState).append("hosts", this.hosts).append("modifiedParameters", this.modifiedParameters).append("originalParameters", this.originalParameters).append("pendingRollingStages", this.pendingRollingStages).append("performingRollback", (Object)this.performingRollback).append("phase", (Object)this.phase).append("preUpdateHosts", this.preUpdateHosts).append("rdsInstanceId", (Object)this.rdsInstanceId).append("rollbackAttemptCount", (Object)this.rollbackAttemptCount).append("rollingStageConsecutiveExceptions", (Object)this.rollingStageConsecutiveExceptions).append("rollingStageExecutionCount", (Object)this.rollingStageExecutionCount).append("rollingStageStartTime", (Object)this.rollingStageStartTime).append("supportedTypes", this.supportedTypes).append("switchToHardUpdateAllowed", (Object)this.switchToHardUpdateAllowed).append("type", (Object)this.type).append("waitingForRetryOrRollback", (Object)this.waitingForRetryOrRollback).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UpdateState updateState) {
        return updateState == null ? UpdateState.empty().toBuilder() : updateState.toBuilder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().type(this.type).supportedTypes(this.supportedTypes).pendingRollingStages(this.pendingRollingStages).completedRollingStages(this.completedRollingStages).rollingStageStartTime(this.rollingStageStartTime).rollingStageConsecutiveExceptions(this.rollingStageConsecutiveExceptions).rollingStageExecutionCount(this.rollingStageExecutionCount).coordinatorDynamicConfiguration(this.coordinatorDynamicConfiguration).preUpdateHosts(this.preUpdateHosts).currentState(this.currentState).rollbackAttemptCount(this.rollbackAttemptCount).originalParameters(this.originalParameters).modifiedParameters(this.modifiedParameters).waitingForRetryOrRollback(this.waitingForRetryOrRollback).cancelAllowed(this.cancelAllowed).performingRollback(this.performingRollback).switchToHardUpdateAllowed(this.switchToHardUpdateAllowed).phase(this.phase).hosts(this.hosts).rdsInstanceId(this.rdsInstanceId);
    }

    @Generated
    private UpdateState(UpdateType type, List<UpdateType> supportedTypes, Deque<Stage> pendingRollingStages, Deque<Stage> completedRollingStages, DateTime rollingStageStartTime, Integer rollingStageConsecutiveExceptions, Integer rollingStageExecutionCount, String coordinatorDynamicConfiguration, List<Host> preUpdateHosts, State currentState, Integer rollbackAttemptCount, Map<String, Object> originalParameters, Map<String, Object> modifiedParameters, Boolean waitingForRetryOrRollback, Boolean cancelAllowed, Boolean performingRollback, Boolean switchToHardUpdateAllowed, UpdatePhase phase, List<String> hosts, String rdsInstanceId) {
        this.type = type;
        this.supportedTypes = supportedTypes;
        this.pendingRollingStages = pendingRollingStages;
        this.completedRollingStages = completedRollingStages;
        this.rollingStageStartTime = rollingStageStartTime;
        this.rollingStageConsecutiveExceptions = rollingStageConsecutiveExceptions;
        this.rollingStageExecutionCount = rollingStageExecutionCount;
        this.coordinatorDynamicConfiguration = coordinatorDynamicConfiguration;
        this.preUpdateHosts = preUpdateHosts;
        this.currentState = currentState;
        this.rollbackAttemptCount = rollbackAttemptCount;
        this.originalParameters = originalParameters;
        this.modifiedParameters = modifiedParameters;
        this.waitingForRetryOrRollback = waitingForRetryOrRollback;
        this.cancelAllowed = cancelAllowed;
        this.performingRollback = performingRollback;
        this.switchToHardUpdateAllowed = switchToHardUpdateAllowed;
        this.phase = phase;
        this.hosts = hosts;
        this.rdsInstanceId = rdsInstanceId;
    }

    @Generated
    private UpdateState() {
        this.type = null;
        this.supportedTypes = null;
        this.pendingRollingStages = null;
        this.completedRollingStages = null;
        this.rollingStageStartTime = null;
        this.rollingStageConsecutiveExceptions = null;
        this.rollingStageExecutionCount = null;
        this.coordinatorDynamicConfiguration = null;
        this.preUpdateHosts = null;
        this.currentState = null;
        this.rollbackAttemptCount = null;
        this.originalParameters = null;
        this.modifiedParameters = null;
        this.waitingForRetryOrRollback = null;
        this.cancelAllowed = null;
        this.performingRollback = null;
        this.switchToHardUpdateAllowed = null;
        this.phase = null;
        this.hosts = null;
        this.rdsInstanceId = null;
    }

    @Generated
    public static UpdateState empty() {
        return new UpdateState();
    }

    @Generated
    public UpdateType getType() {
        return this.type;
    }

    @Generated
    public List<UpdateType> getSupportedTypes() {
        return this.supportedTypes;
    }

    @Generated
    public Deque<Stage> getPendingRollingStages() {
        return this.pendingRollingStages;
    }

    @Generated
    public Deque<Stage> getCompletedRollingStages() {
        return this.completedRollingStages;
    }

    @Generated
    public DateTime getRollingStageStartTime() {
        return this.rollingStageStartTime;
    }

    @Generated
    public Integer getRollingStageConsecutiveExceptions() {
        return this.rollingStageConsecutiveExceptions;
    }

    @Generated
    public Integer getRollingStageExecutionCount() {
        return this.rollingStageExecutionCount;
    }

    @Generated
    public String getCoordinatorDynamicConfiguration() {
        return this.coordinatorDynamicConfiguration;
    }

    @Generated
    public List<Host> getPreUpdateHosts() {
        return this.preUpdateHosts;
    }

    @Generated
    public State getCurrentState() {
        return this.currentState;
    }

    @Generated
    public Integer getRollbackAttemptCount() {
        return this.rollbackAttemptCount;
    }

    @Generated
    public Map<String, Object> getOriginalParameters() {
        return this.originalParameters;
    }

    @Generated
    public Map<String, Object> getModifiedParameters() {
        return this.modifiedParameters;
    }

    @Generated
    public Boolean getWaitingForRetryOrRollback() {
        return this.waitingForRetryOrRollback;
    }

    @Generated
    public Boolean getCancelAllowed() {
        return this.cancelAllowed;
    }

    @Generated
    public Boolean getPerformingRollback() {
        return this.performingRollback;
    }

    @Generated
    public Boolean getSwitchToHardUpdateAllowed() {
        return this.switchToHardUpdateAllowed;
    }

    @Generated
    public UpdatePhase getPhase() {
        return this.phase;
    }

    @Generated
    public List<String> getHosts() {
        return this.hosts;
    }

    @Generated
    public String getRdsInstanceId() {
        return this.rdsInstanceId;
    }

    public static enum UpdatePhase {
        PENDING,
        CREATING_SNAPSHOT,
        UPDATING_CF_STACK,
        UPDATING_CLUSTER,
        UNKNOWN,
        NOT_SET;

    }

    public static class Builder {
        @Generated
        private UpdateType type;
        @Generated
        private List<UpdateType> supportedTypes;
        @Generated
        private Deque<Stage> pendingRollingStages;
        @Generated
        private Deque<Stage> completedRollingStages;
        @Generated
        private DateTime rollingStageStartTime;
        @Generated
        private Integer rollingStageConsecutiveExceptions;
        @Generated
        private Integer rollingStageExecutionCount;
        @Generated
        private String coordinatorDynamicConfiguration;
        @Generated
        private List<Host> preUpdateHosts;
        @Generated
        private State currentState;
        @Generated
        private Integer rollbackAttemptCount;
        @Generated
        private Map<String, Object> originalParameters;
        @Generated
        private Map<String, Object> modifiedParameters;
        @Generated
        private Boolean waitingForRetryOrRollback;
        @Generated
        private Boolean cancelAllowed;
        @Generated
        private Boolean performingRollback;
        @Generated
        private Boolean switchToHardUpdateAllowed;
        @Generated
        private UpdatePhase phase;
        @Generated
        private List<String> hosts;
        @Generated
        private String rdsInstanceId;

        public Builder clearTimerAndCounters() {
            this.rollingStageStartTime = Constants.CLEAR_FIELD_DATETIME;
            this.rollingStageConsecutiveExceptions = Constants.CLEAR_FIELD_INT;
            this.rollingStageExecutionCount = Constants.CLEAR_FIELD_INT;
            return this;
        }

        @Generated
        Builder() {
        }

        @JsonProperty
        @Generated
        public Builder type(UpdateType type) {
            this.type = type;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder supportedTypes(List<UpdateType> supportedTypes) {
            this.supportedTypes = supportedTypes;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder pendingRollingStages(Deque<Stage> pendingRollingStages) {
            this.pendingRollingStages = pendingRollingStages;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder completedRollingStages(Deque<Stage> completedRollingStages) {
            this.completedRollingStages = completedRollingStages;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder rollingStageStartTime(DateTime rollingStageStartTime) {
            this.rollingStageStartTime = rollingStageStartTime;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder rollingStageConsecutiveExceptions(Integer rollingStageConsecutiveExceptions) {
            this.rollingStageConsecutiveExceptions = rollingStageConsecutiveExceptions;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder rollingStageExecutionCount(Integer rollingStageExecutionCount) {
            this.rollingStageExecutionCount = rollingStageExecutionCount;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder coordinatorDynamicConfiguration(String coordinatorDynamicConfiguration) {
            this.coordinatorDynamicConfiguration = coordinatorDynamicConfiguration;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder preUpdateHosts(List<Host> preUpdateHosts) {
            this.preUpdateHosts = preUpdateHosts;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder currentState(State currentState) {
            this.currentState = currentState;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder rollbackAttemptCount(Integer rollbackAttemptCount) {
            this.rollbackAttemptCount = rollbackAttemptCount;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder originalParameters(Map<String, Object> originalParameters) {
            this.originalParameters = originalParameters;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder modifiedParameters(Map<String, Object> modifiedParameters) {
            this.modifiedParameters = modifiedParameters;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder waitingForRetryOrRollback(Boolean waitingForRetryOrRollback) {
            this.waitingForRetryOrRollback = waitingForRetryOrRollback;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder cancelAllowed(Boolean cancelAllowed) {
            this.cancelAllowed = cancelAllowed;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder performingRollback(Boolean performingRollback) {
            this.performingRollback = performingRollback;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder switchToHardUpdateAllowed(Boolean switchToHardUpdateAllowed) {
            this.switchToHardUpdateAllowed = switchToHardUpdateAllowed;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder phase(UpdatePhase phase) {
            this.phase = phase;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder hosts(List<String> hosts) {
            this.hosts = hosts;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder rdsInstanceId(String rdsInstanceId) {
            this.rdsInstanceId = rdsInstanceId;
            return this;
        }

        @Generated
        public UpdateState build() {
            return new UpdateState(this.type, this.supportedTypes, this.pendingRollingStages, this.completedRollingStages, this.rollingStageStartTime, this.rollingStageConsecutiveExceptions, this.rollingStageExecutionCount, this.coordinatorDynamicConfiguration, this.preUpdateHosts, this.currentState, this.rollbackAttemptCount, this.originalParameters, this.modifiedParameters, this.waitingForRetryOrRollback, this.cancelAllowed, this.performingRollback, this.switchToHardUpdateAllowed, this.phase, this.hosts, this.rdsInstanceId);
        }

        @Generated
        public String toString() {
            return "UpdateState.Builder(type=" + String.valueOf((Object)this.type) + ", supportedTypes=" + String.valueOf(this.supportedTypes) + ", pendingRollingStages=" + String.valueOf(this.pendingRollingStages) + ", completedRollingStages=" + String.valueOf(this.completedRollingStages) + ", rollingStageStartTime=" + String.valueOf(this.rollingStageStartTime) + ", rollingStageConsecutiveExceptions=" + this.rollingStageConsecutiveExceptions + ", rollingStageExecutionCount=" + this.rollingStageExecutionCount + ", coordinatorDynamicConfiguration=" + this.coordinatorDynamicConfiguration + ", preUpdateHosts=" + String.valueOf(this.preUpdateHosts) + ", currentState=" + String.valueOf((Object)this.currentState) + ", rollbackAttemptCount=" + this.rollbackAttemptCount + ", originalParameters=" + String.valueOf(this.originalParameters) + ", modifiedParameters=" + String.valueOf(this.modifiedParameters) + ", waitingForRetryOrRollback=" + this.waitingForRetryOrRollback + ", cancelAllowed=" + this.cancelAllowed + ", performingRollback=" + this.performingRollback + ", switchToHardUpdateAllowed=" + this.switchToHardUpdateAllowed + ", phase=" + String.valueOf((Object)this.phase) + ", hosts=" + String.valueOf(this.hosts) + ", rdsInstanceId=" + this.rdsInstanceId + ")";
        }
    }
}

