/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.google.common.base.Preconditions;
import io.imply.cloud.util.IAE;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ServiceTier {
    public static final ServiceTier TIER_1 = new ServiceTier("Tier1");
    public static final ServiceTier TIER_2 = new ServiceTier("Tier2");
    public static final ServiceTier TIER_3 = new ServiceTier("Tier3");
    private final String customDruidPropertiesKeySuffix;

    public String getCustomDruidPropertiesKeySuffix() {
        return this.customDruidPropertiesKeySuffix;
    }

    public static ServiceTier fromInteger(int tier) {
        switch (tier) {
            case 1: {
                return TIER_1;
            }
            case 2: {
                return TIER_2;
            }
            case 3: {
                return TIER_3;
            }
        }
        return new ServiceTier("Tier" + tier);
    }

    public static ServiceTier fromSuffix(String suffix) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)suffix) ? 1 : 0) != 0, (Object)"ServiceTier suffix cannot be null or empty");
        String[] suffixParts = suffix.split("Tier");
        if (suffixParts.length < 2) {
            throw new IAE(String.format("ServiceTier suffix %s is invalid", suffix), new Object[0]);
        }
        return ServiceTier.fromInteger(Integer.parseInt(suffixParts[1]));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceTier)) {
            return false;
        }
        ServiceTier other = (ServiceTier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$customDruidPropertiesKeySuffix = this.getCustomDruidPropertiesKeySuffix();
        String other$customDruidPropertiesKeySuffix = other.getCustomDruidPropertiesKeySuffix();
        return !(this$customDruidPropertiesKeySuffix == null ? other$customDruidPropertiesKeySuffix != null : !this$customDruidPropertiesKeySuffix.equals(other$customDruidPropertiesKeySuffix));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceTier;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $customDruidPropertiesKeySuffix = this.getCustomDruidPropertiesKeySuffix();
        result = result * 59 + ($customDruidPropertiesKeySuffix == null ? 43 : $customDruidPropertiesKeySuffix.hashCode());
        return result;
    }

    @Generated
    private ServiceTier(String customDruidPropertiesKeySuffix) {
        this.customDruidPropertiesKeySuffix = customDruidPropertiesKeySuffix;
    }
}

