/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.HorizontalQueryUnitType;
import io.imply.cloud.model.Scalable;
import io.imply.cloud.model.VerticalQueryUnitType;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="scaling")
@JsonSubTypes(value={@JsonSubTypes.Type(name="horizontal", value=HorizontalQueryUnitType.class), @JsonSubTypes.Type(name="vertical", value=VerticalQueryUnitType.class)})
public abstract class QueryUnitType
implements Scalable {
    @JsonProperty
    private ComparableVersion minImplyVersion;
    @JsonProperty
    private Integer instanceCount;

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("instanceCount", (Object)this.instanceCount).toString();
    }

    public abstract Integer getCpu(InstanceTypeHelper var1);

    public abstract Integer getMemory(InstanceTypeHelper var1);

    public abstract Integer getMinCount();

    public abstract Integer getMaxCount();

    public abstract String getInstanceType();

    public static QueryUnitType getForComparableImplyVersion(String unitType, ComparableVersion comparableVersion, RefreshableConstants refreshableConstants) {
        if (StringUtils.isBlank((CharSequence)unitType) || comparableVersion == null) {
            return null;
        }
        Map<String, List<QueryUnitType>> unitTypeMap = refreshableConstants.getQueryUnitTypeMap();
        if (!unitTypeMap.containsKey(unitType)) {
            return null;
        }
        List<QueryUnitType> versionedSizeDetails = unitTypeMap.get(unitType);
        return versionedSizeDetails.stream().sorted(Comparator.comparing(QueryUnitType::getMinImplyVersion).reversed()).filter(x -> comparableVersion.compareTo(x.getMinImplyVersion()) >= 0).findFirst().orElse(null);
    }

    @Generated
    protected QueryUnitType(Builder<?, ?> b) {
        this.minImplyVersion = b.minImplyVersion;
        this.instanceCount = b.instanceCount;
    }

    @Generated
    public QueryUnitType(ComparableVersion minImplyVersion, Integer instanceCount) {
        this.minImplyVersion = minImplyVersion;
        this.instanceCount = instanceCount;
    }

    @Generated
    protected QueryUnitType() {
    }

    @Generated
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @Generated
    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryUnitType)) {
            return false;
        }
        QueryUnitType other = (QueryUnitType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$instanceCount = this.getInstanceCount();
        Integer other$instanceCount = other.getInstanceCount();
        if (this$instanceCount == null ? other$instanceCount != null : !((Object)this$instanceCount).equals(other$instanceCount)) {
            return false;
        }
        ComparableVersion this$minImplyVersion = this.getMinImplyVersion();
        ComparableVersion other$minImplyVersion = other.getMinImplyVersion();
        return !(this$minImplyVersion == null ? other$minImplyVersion != null : !((Object)this$minImplyVersion).equals(other$minImplyVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueryUnitType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $instanceCount = this.getInstanceCount();
        result = result * 59 + ($instanceCount == null ? 43 : ((Object)$instanceCount).hashCode());
        ComparableVersion $minImplyVersion = this.getMinImplyVersion();
        result = result * 59 + ($minImplyVersion == null ? 43 : ((Object)$minImplyVersion).hashCode());
        return result;
    }

    @Generated
    public static abstract class Builder<C extends QueryUnitType, B extends Builder<C, B>> {
        @Generated
        private ComparableVersion minImplyVersion;
        @Generated
        private Integer instanceCount;

        @JsonProperty
        @Generated
        public B minImplyVersion(ComparableVersion minImplyVersion) {
            this.minImplyVersion = minImplyVersion;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "QueryUnitType.Builder(minImplyVersion=" + String.valueOf(this.minImplyVersion) + ", instanceCount=" + this.instanceCount + ")";
        }
    }
}

