/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.ImplyView;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Optional;
import lombok.Generated;

public class ProjectPlan {
    @JsonView(value={ImplyView.View.Public.class})
    @JsonProperty
    private final String name;
    @JsonView(value={ImplyView.View.Public.class})
    @JsonProperty
    private final Long maxBytes;
    @JsonView(value={ImplyView.View.Public.class})
    @JsonProperty
    private final String memory;
    @JsonView(value={ImplyView.View.Public.class})
    @JsonProperty
    private final String cpu;

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).append("maxBytes", (Object)this.maxBytes).append("memory", (Object)this.memory).append("cpu", (Object)this.cpu).toString();
    }

    public static Optional<Long> getMaxBytesByName(String name, RefreshableConstants refreshableConstants) {
        return refreshableConstants.getProjectPlans().stream().filter(p -> p.getName().equals(name)).map(ProjectPlan::getMaxBytes).findAny();
    }

    public static Optional<ProjectPlan> getByName(String name, RefreshableConstants refreshableConstants) {
        return refreshableConstants.getProjectPlans().stream().filter(p -> p.getName().equals(name)).findAny();
    }

    public static String getSeriesByName(String name) {
        String[] plan = name.split("\\.");
        if (plan.length < 2) {
            throw new IAE("plan %s does not match expected naming pattern", name);
        }
        return plan[0];
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    private ProjectPlan() {
        this.name = null;
        this.maxBytes = null;
        this.memory = null;
        this.cpu = null;
    }

    @Generated
    public ProjectPlan(String name, Long maxBytes, String memory, String cpu) {
        this.name = name;
        this.maxBytes = maxBytes;
        this.memory = memory;
        this.cpu = cpu;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getMaxBytes() {
        return this.maxBytes;
    }

    @Generated
    public String getMemory() {
        return this.memory;
    }

    @Generated
    public String getCpu() {
        return this.cpu;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectPlan)) {
            return false;
        }
        ProjectPlan other = (ProjectPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$maxBytes = this.getMaxBytes();
        Long other$maxBytes = other.getMaxBytes();
        if (this$maxBytes == null ? other$maxBytes != null : !((Object)this$maxBytes).equals(other$maxBytes)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$memory = this.getMemory();
        String other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) {
            return false;
        }
        String this$cpu = this.getCpu();
        String other$cpu = other.getCpu();
        return !(this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProjectPlan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $maxBytes = this.getMaxBytes();
        result = result * 59 + ($maxBytes == null ? 43 : ((Object)$maxBytes).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : $memory.hashCode());
        String $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : $cpu.hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private String name;
        @Generated
        private Long maxBytes;
        @Generated
        private String memory;
        @Generated
        private String cpu;

        @Generated
        Builder() {
        }

        @JsonView(value={ImplyView.View.Public.class})
        @JsonProperty
        @Generated
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonView(value={ImplyView.View.Public.class})
        @JsonProperty
        @Generated
        public Builder maxBytes(Long maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        @JsonView(value={ImplyView.View.Public.class})
        @JsonProperty
        @Generated
        public Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        @JsonView(value={ImplyView.View.Public.class})
        @JsonProperty
        @Generated
        public Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        @Generated
        public ProjectPlan build() {
            return new ProjectPlan(this.name, this.maxBytes, this.memory, this.cpu);
        }

        @Generated
        public String toString() {
            return "ProjectPlan.Builder(name=" + this.name + ", maxBytes=" + this.maxBytes + ", memory=" + this.memory + ", cpu=" + this.cpu + ")";
        }
    }
}

