/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.Constants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.Mergeable;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.util.DiffUtils;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ToStringBuilder;
import io.imply.cloud.util.YAML;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.Diffable;
import org.apache.commons.lang3.builder.ReflectionDiffBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Pivot
implements Mergeable<Pivot>,
Diffable<Pivot> {
    @Generated
    private static final Logger log = Logger.from(Pivot.class);
    private static final YAML YAML = new YAML();
    @JsonProperty
    private final Type type;
    @JsonProperty
    private final String url;
    @JsonProperty
    private final RoleAuthority roleAuthority;
    @JsonProperty
    private final String options;

    public Pivot merge(Pivot other) {
        if (other == null) {
            return this;
        }
        return new Pivot((Type)((Object)ObjectUtils.defaultIfNull((Object)((Object)other.type), (Object)((Object)this.type))), (String)ObjectUtils.defaultIfNull((Object)other.url, (Object)this.url), (RoleAuthority)((Object)ObjectUtils.defaultIfNull((Object)((Object)other.roleAuthority), (Object)((Object)this.roleAuthority))), (String)ObjectUtils.defaultIfNull((Object)other.options, (Object)this.options));
    }

    @Override
    public Pivot mergeDiff(Pivot other) {
        if (other == null) {
            return this;
        }
        return new Pivot(DiffUtils.nullIf(this.type, other.type), DiffUtils.nullIf(this.url, other.url), DiffUtils.nullIf(this.roleAuthority, other.roleAuthority), StringUtils.equals((CharSequence)this.options, (CharSequence)other.options) ? null : this.options);
    }

    public DiffResult<Pivot> diff(Pivot other) {
        return new ReflectionDiffBuilder((Object)this, (Object)other, ToStringStyle.SHORT_PREFIX_STYLE).build();
    }

    public Pivot filterNonNullFields(Pivot filter) {
        if (filter == null) {
            return new Pivot();
        }
        return new Pivot(filter.type == null ? null : this.type, filter.url == null ? null : this.url, filter.roleAuthority == null ? null : this.roleAuthority, filter.options == null ? null : this.options);
    }

    public Pivot withDefaultsForUnset() {
        Type type;
        return new Pivot(type, this.url, (type = (Type)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.type), (Object)((Object)Type.PROXIED)))).isConfigurable() ? (RoleAuthority)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.roleAuthority), (Object)((Object)RoleAuthority.EXTERNAL))) : null, this.options);
    }

    public void validate(List<ImplyConstraintViolation> results) {
        if (this.type == null) {
            results.add(ImplyConstraintViolation.error("pivot.type", "[pivot.type] must be set", new Object[0]));
            return;
        }
        if (this.type.isConfigurable() && this.roleAuthority == null) {
            results.add(ImplyConstraintViolation.error("pivot.roleAuthority", "[pivot.roleAuthority] must be set", new Object[0]));
        }
        if (this.type.isConfigurable() && !YAML.isYaml(this.options)) {
            results.add(ImplyConstraintViolation.error("pivot.options", "[pivot.options] is not valid YAML", new Object[0]));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.type == null && this.url == null && this.roleAuthority == null && this.options == null;
    }

    public Map<String, Object> getConfig() throws IOException {
        if (this.type == null || this.type == Type.PROXIED) {
            return ImmutableMap.of((Object)"userMode", (Object)"header-user");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.type == Type.NATIVE) {
            builder.put((Object)"userMode", (Object)"native-users");
        } else if (this.type == Type.OIDC) {
            builder.put((Object)"userMode", (Object)"oidc-authentication").put((Object)"roleAuthority", (Object)this.roleAuthority).put((Object)"oidcOptions", YAML.fromYaml(this.options));
        } else if (this.type == Type.LDAP) {
            builder.put((Object)"userMode", (Object)"ldap-authentication").put((Object)"roleAuthority", (Object)this.roleAuthority).put((Object)"ldapOptions", YAML.fromYaml(this.options));
        }
        if (StringUtils.isNotBlank((CharSequence)this.url)) {
            try {
                String path;
                URI parsed = new URI(this.url);
                if (StringUtils.isBlank((CharSequence)parsed.getScheme())) {
                    parsed = new URI("http://" + this.url);
                }
                if (StringUtils.isNotBlank((CharSequence)(path = StringUtils.strip((String)parsed.getPath(), (String)"/")))) {
                    builder.put((Object)"serverRoot", (Object)path);
                }
            }
            catch (URISyntaxException e) {
                log.warn(e, "Could not parse url [%s], skipping setting serverRoot", this.url);
            }
            builder.put((Object)"linkHostName", (Object)this.url);
        }
        return builder.build();
    }

    public boolean requiresLicense() {
        return this.type != Type.PROXIED;
    }

    public String toString() {
        return new ToStringBuilder(this).append("type", (Object)this.type).append("url", (Object)this.url).append("roleAuthority", (Object)this.roleAuthority).append("options", (Object)this.options).toString();
    }

    public List<Set<UpdateDetails>> getSupportedUpdatesForDiff(boolean hasMultipleMasterNodes) {
        return this.isEmpty() ? ImmutableList.of() : Pivot.getSupportedUpdates(hasMultipleMasterNodes);
    }

    public List<Set<UpdateDetails>> getSupportedUpdatesForDiff(Diff<Pivot> diff, boolean hasMultipleMasterNodes) {
        return Pivot.getSupportedUpdates(hasMultipleMasterNodes);
    }

    private static List<Set<UpdateDetails>> getSupportedUpdates(boolean hasMultipleMasterNodes) {
        if (hasMultipleMasterNodes) {
            return ImmutableList.of((Object)ImmutableSet.of((Object)UpdateDetails.hard(10), (Object)UpdateDetails.rolling(999)));
        }
        return ImmutableList.of((Object)ImmutableSet.of((Object)UpdateDetails.hard(10)));
    }

    public static Map<String, Type> getForImplyVersion(ImplyVersion implyVersion, ApplicationConfig applicationConfig) {
        if (!applicationConfig.isAWS() && !applicationConfig.isKubernetesMode()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"proxied", (Object)Type.PROXIED);
        if (implyVersion.getComparableVersion().compareTo(Constants.MIN_IMPLY_VERSION_CONFIGURABLE_PIVOT) < 0) {
            return builder.build();
        }
        return builder.put((Object)"native", (Object)Type.NATIVE).put((Object)"ldap", (Object)Type.LDAP).put((Object)"oidc", (Object)Type.OIDC).build();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().type(this.type).url(this.url).roleAuthority(this.roleAuthority).options(this.options);
    }

    @Generated
    private Pivot() {
        this.type = null;
        this.url = null;
        this.roleAuthority = null;
        this.options = null;
    }

    @Generated
    public Pivot(Type type, String url, RoleAuthority roleAuthority, String options) {
        this.type = type;
        this.url = url;
        this.roleAuthority = roleAuthority;
        this.options = options;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public RoleAuthority getRoleAuthority() {
        return this.roleAuthority;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pivot)) {
            return false;
        }
        Pivot other = (Pivot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        RoleAuthority this$roleAuthority = this.getRoleAuthority();
        RoleAuthority other$roleAuthority = other.getRoleAuthority();
        if (this$roleAuthority == null ? other$roleAuthority != null : !((Object)((Object)this$roleAuthority)).equals((Object)other$roleAuthority)) {
            return false;
        }
        String this$options = this.getOptions();
        String other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !this$options.equals(other$options));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pivot;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        RoleAuthority $roleAuthority = this.getRoleAuthority();
        result = result * 59 + ($roleAuthority == null ? 43 : ((Object)((Object)$roleAuthority)).hashCode());
        String $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        return result;
    }

    public static enum Type {
        PROXIED(false),
        NATIVE(false),
        OIDC(true),
        LDAP(true);

        private final boolean configurable;

        @JsonValue
        public String lowerCaseName() {
            return this.name().toLowerCase();
        }

        @Generated
        private Type(boolean configurable) {
            this.configurable = configurable;
        }

        @Generated
        public boolean isConfigurable() {
            return this.configurable;
        }
    }

    public static enum RoleAuthority {
        NATIVE,
        EXTERNAL;


        @JsonValue
        public String lowerCaseName() {
            return this.name().toLowerCase();
        }
    }

    @Generated
    public static class Builder {
        @Generated
        private Type type;
        @Generated
        private String url;
        @Generated
        private RoleAuthority roleAuthority;
        @Generated
        private String options;

        @Generated
        Builder() {
        }

        @JsonProperty
        @Generated
        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder roleAuthority(RoleAuthority roleAuthority) {
            this.roleAuthority = roleAuthority;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder options(String options) {
            this.options = options;
            return this;
        }

        @Generated
        public Pivot build() {
            return new Pivot(this.type, this.url, this.roleAuthority, this.options);
        }

        @Generated
        public String toString() {
            return "Pivot.Builder(type=" + String.valueOf((Object)this.type) + ", url=" + this.url + ", roleAuthority=" + String.valueOf((Object)this.roleAuthority) + ", options=" + this.options + ")";
        }
    }
}

