/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;

public class JdbcURIParser {
    private String host;
    private Integer port;
    private String query;
    private String path;
    private String protocol;

    public static JdbcURIParser parse(String jdbcString) throws URISyntaxException {
        String connectURINoJDBC = jdbcString.replaceFirst("^jdbc:", "");
        String protocol = "";
        URI uri = new URI(connectURINoJDBC);
        if (uri.getHost() == null) {
            String protocolPrefix = connectURINoJDBC.split(":")[0];
            protocol = connectURINoJDBC.split("://")[0];
            uri = new URI(connectURINoJDBC.replace(protocol, protocolPrefix));
        }
        return JdbcURIParser.builder().host(uri.getHost()).port(uri.getPort()).query(uri.getQuery()).path(uri.getPath()).protocol(protocol).build();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public JdbcURIParser(String host, Integer port, String query, String path, String protocol) {
        this.host = host;
        this.port = port;
        this.query = query;
        this.path = path;
        this.protocol = protocol;
    }

    @Generated
    public static class Builder {
        @Generated
        private String host;
        @Generated
        private Integer port;
        @Generated
        private String query;
        @Generated
        private String path;
        @Generated
        private String protocol;

        @Generated
        Builder() {
        }

        @Generated
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public Builder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        public Builder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public JdbcURIParser build() {
            return new JdbcURIParser(this.host, this.port, this.query, this.path, this.protocol);
        }

        @Generated
        public String toString() {
            return "JdbcURIParser.Builder(host=" + this.host + ", port=" + this.port + ", query=" + this.query + ", path=" + this.path + ", protocol=" + this.protocol + ")";
        }
    }
}

