/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.model.Host;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceHealth;
import io.imply.cloud.model.Status;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Instance
implements Host {
    private final String instanceId;
    private final String instanceType;
    private final String state;
    private final String privateIpAddress;
    private final String publicIpAddress;
    private final String internalUsePrivateIpAddress;
    private final Boolean preferPublicIpAddress;
    private final Boolean modifiable;
    private final Boolean online;
    private final Boolean implyRunning;
    private final String implyVersion;
    private final Integer clusterVersion;
    private final List<ImplyNodeType> implyNodeTypes;
    private final InstanceHealth health;
    private final DateTime launchTime;
    private final String hostname;

    @JsonCreator
    public Instance(@JsonProperty(value="instanceId") String instanceId, @JsonProperty(value="instanceType") String instanceType, @JsonProperty(value="state") String state, @JsonProperty(value="privateIpAddress") String privateIpAddress, @JsonProperty(value="publicIpAddress") String publicIpAddress, @JsonProperty(value="internalUsePrivateIpAddress") String internalUsePrivateIpAddress, @JsonProperty(value="preferPublicIpAddress") Boolean preferPublicIpAddress, @JsonProperty(value="modifiable") Boolean modifiable, @JsonProperty(value="online") Boolean online, @JsonProperty(value="implyRunning") Boolean implyRunning, @JsonProperty(value="implyVersion") String implyVersion, @JsonProperty(value="clusterVersion") Integer clusterVersion, @JsonProperty(value="implyNodeTypes") List<ImplyNodeType> implyNodeTypes, @JsonProperty(value="health") InstanceHealth health, @JsonProperty(value="launchTime") DateTime launchTime, @JsonProperty(value="hostname") String hostname) {
        this.instanceId = instanceId;
        this.instanceType = instanceType;
        this.state = state;
        this.privateIpAddress = privateIpAddress;
        this.publicIpAddress = publicIpAddress;
        this.internalUsePrivateIpAddress = internalUsePrivateIpAddress;
        this.preferPublicIpAddress = preferPublicIpAddress;
        this.modifiable = modifiable;
        this.online = online;
        this.implyRunning = implyRunning;
        this.implyVersion = implyVersion;
        this.clusterVersion = clusterVersion;
        this.implyNodeTypes = implyNodeTypes;
        this.health = health;
        this.launchTime = launchTime;
        this.hostname = hostname;
    }

    @JsonProperty
    public String getInstanceId() {
        return this.instanceId;
    }

    @JsonProperty
    public String getInstanceType() {
        return this.instanceType;
    }

    @JsonProperty
    public String getState() {
        return this.state;
    }

    @JsonProperty
    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    @JsonProperty
    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    @JsonProperty
    public String getInternalUsePrivateIpAddress() {
        return this.internalUsePrivateIpAddress;
    }

    public Boolean isPreferPublicIpAddress() {
        return this.preferPublicIpAddress;
    }

    @JsonProperty
    public Boolean isModifiable() {
        return this.modifiable;
    }

    @JsonProperty
    public Boolean isOnline() {
        return this.online;
    }

    @JsonProperty
    public Boolean isImplyRunning() {
        return this.implyRunning;
    }

    @JsonProperty
    public String getImplyVersion() {
        return this.implyVersion;
    }

    @JsonProperty
    public Integer getClusterVersion() {
        return this.clusterVersion;
    }

    @JsonProperty
    public List<ImplyNodeType> getImplyNodeTypes() {
        return this.implyNodeTypes;
    }

    @JsonProperty
    public InstanceHealth getHealth() {
        return this.health;
    }

    @JsonProperty
    public Status getStatus() {
        if (this.online != null && !this.online.booleanValue()) {
            return Status.OFFLINE;
        }
        if (this.implyRunning != null && !this.implyRunning.booleanValue()) {
            return Status.IMPLY_NOT_RUNNING;
        }
        if (this.health == null) {
            return this.online != null && this.implyRunning != null ? Status.WAITING_FOR_STATUS : Status.UNKNOWN;
        }
        if (this.health.getConsecutiveSuccessCount() == null && this.health.getConsecutiveFailureCount() == null) {
            return Status.WAITING_FOR_STATUS;
        }
        if (this.health.getConsecutiveFailureCount() != null && this.health.getConsecutiveFailureCount() >= 5) {
            return Status.WARNING;
        }
        return Status.OK;
    }

    @JsonProperty
    public DateTime getLaunchTime() {
        return this.launchTime;
    }

    @JsonProperty
    public String getHostname() {
        return this.hostname;
    }

    public String toString() {
        return new ToStringBuilder(this).append("instanceId", this.instanceId).append("instanceType", (Object)this.instanceType).append("state", (Object)this.state).append("privateIpAddress", (Object)this.privateIpAddress).append("publicIpAddress", (Object)this.publicIpAddress).append("internalUsePrivateIpAddress", (Object)this.internalUsePrivateIpAddress).append("preferPublicIpAddress", (Object)this.preferPublicIpAddress).append("modifiable", (Object)this.modifiable).append("online", (Object)this.online).append("implyRunning", (Object)this.implyRunning).append("implyVersion", (Object)this.implyVersion).append("clusterVersion", (Object)this.clusterVersion).append("implyNodeTypes", this.implyNodeTypes).append("health", (Object)this.health).append("launchTime", (Object)this.launchTime).append("hostname", (Object)this.hostname).toString();
    }

    @Override
    public String getAddress() {
        return this.preferPublicIpAddress != null && this.preferPublicIpAddress != false ? this.publicIpAddress : this.privateIpAddress;
    }

    @Override
    public String getId() {
        return this.instanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instance instance = (Instance)o;
        return Objects.equals(this.instanceId, instance.instanceId) && Objects.equals(this.instanceType, instance.instanceType) && Objects.equals(this.state, instance.state) && Objects.equals(this.privateIpAddress, instance.privateIpAddress) && Objects.equals(this.publicIpAddress, instance.publicIpAddress) && Objects.equals(this.internalUsePrivateIpAddress, instance.internalUsePrivateIpAddress) && Objects.equals(this.preferPublicIpAddress, instance.preferPublicIpAddress) && Objects.equals(this.modifiable, instance.modifiable) && Objects.equals(this.online, instance.online) && Objects.equals(this.implyRunning, instance.implyRunning) && Objects.equals(this.implyVersion, instance.implyVersion) && Objects.equals(this.clusterVersion, instance.clusterVersion) && Objects.equals(this.implyNodeTypes, instance.implyNodeTypes) && Objects.equals(this.health, instance.health) && Objects.equals(this.launchTime, instance.launchTime) && Objects.equals(this.hostname, instance.hostname);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.instanceType, this.state, this.privateIpAddress, this.publicIpAddress, this.internalUsePrivateIpAddress, this.preferPublicIpAddress, this.modifiable, this.online, this.implyRunning, this.implyVersion, this.clusterVersion, this.implyNodeTypes, this.health, this.launchTime, this.hostname);
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public static class Builder {
        @Generated
        private String instanceId;
        @Generated
        private String instanceType;
        @Generated
        private String state;
        @Generated
        private String privateIpAddress;
        @Generated
        private String publicIpAddress;
        @Generated
        private String internalUsePrivateIpAddress;
        @Generated
        private Boolean preferPublicIpAddress;
        @Generated
        private Boolean modifiable;
        @Generated
        private Boolean online;
        @Generated
        private Boolean implyRunning;
        @Generated
        private String implyVersion;
        @Generated
        private Integer clusterVersion;
        @Generated
        private List<ImplyNodeType> implyNodeTypes;
        @Generated
        private InstanceHealth health;
        @Generated
        private DateTime launchTime;
        @Generated
        private String hostname;

        @Generated
        Builder() {
        }

        @Generated
        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @Generated
        public Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Generated
        public Builder state(String state) {
            this.state = state;
            return this;
        }

        @Generated
        public Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        @Generated
        public Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        @Generated
        public Builder internalUsePrivateIpAddress(String internalUsePrivateIpAddress) {
            this.internalUsePrivateIpAddress = internalUsePrivateIpAddress;
            return this;
        }

        @Generated
        public Builder preferPublicIpAddress(Boolean preferPublicIpAddress) {
            this.preferPublicIpAddress = preferPublicIpAddress;
            return this;
        }

        @Generated
        public Builder modifiable(Boolean modifiable) {
            this.modifiable = modifiable;
            return this;
        }

        @Generated
        public Builder online(Boolean online) {
            this.online = online;
            return this;
        }

        @Generated
        public Builder implyRunning(Boolean implyRunning) {
            this.implyRunning = implyRunning;
            return this;
        }

        @Generated
        public Builder implyVersion(String implyVersion) {
            this.implyVersion = implyVersion;
            return this;
        }

        @Generated
        public Builder clusterVersion(Integer clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        @Generated
        public Builder implyNodeTypes(List<ImplyNodeType> implyNodeTypes) {
            this.implyNodeTypes = implyNodeTypes;
            return this;
        }

        @Generated
        public Builder health(InstanceHealth health) {
            this.health = health;
            return this;
        }

        @Generated
        public Builder launchTime(DateTime launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        @Generated
        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public Instance build() {
            return new Instance(this.instanceId, this.instanceType, this.state, this.privateIpAddress, this.publicIpAddress, this.internalUsePrivateIpAddress, this.preferPublicIpAddress, this.modifiable, this.online, this.implyRunning, this.implyVersion, this.clusterVersion, this.implyNodeTypes, this.health, this.launchTime, this.hostname);
        }

        @Generated
        public String toString() {
            return "Instance.Builder(instanceId=" + this.instanceId + ", instanceType=" + this.instanceType + ", state=" + this.state + ", privateIpAddress=" + this.privateIpAddress + ", publicIpAddress=" + this.publicIpAddress + ", internalUsePrivateIpAddress=" + this.internalUsePrivateIpAddress + ", preferPublicIpAddress=" + this.preferPublicIpAddress + ", modifiable=" + this.modifiable + ", online=" + this.online + ", implyRunning=" + this.implyRunning + ", implyVersion=" + this.implyVersion + ", clusterVersion=" + this.clusterVersion + ", implyNodeTypes=" + String.valueOf(this.implyNodeTypes) + ", health=" + String.valueOf(this.health) + ", launchTime=" + String.valueOf(this.launchTime) + ", hostname=" + this.hostname + ")";
        }
    }
}

