/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.imply.cloud.Constants;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Info {
    protected final String key;
    protected final String entityId;
    protected final EntityType entityType;
    protected final State desiredState;
    protected final State state;
    protected final DateTime lastModified;
    protected final DateTime lastStateChange;
    protected final List<UpdateDetails> availableUpdateTypes;
    protected final Map<String, String> context;
    protected final Integer proposedClusterVersion;
    protected final Integer deployedClusterVersion;
    protected final Integer proposedClusterNodesVersion;
    protected final Integer deployedClusterNodesVersion;
    protected final Integer configServerClusterVersion;
    protected final UpdateType updateType;
    protected final Integer maxSurgeCount;
    protected final DateTime frequentStatusRefreshUntil;
    protected final UpdateState updateState;
    protected final DateTime lastInstanceHealthCheck;
    protected final Boolean mockEntity;
    protected final DateTime notificationCutoff;
    protected final List<State> transitionStateChain;
    protected final Boolean clearExistingContextOnMerge;
    protected final Boolean clearExistingUpdateState;

    @JsonCreator
    public Info(@JsonProperty(value="key") String key, @JsonProperty(value="entityId") String entityId, @JsonProperty(value="entityType") EntityType entityType, @JsonProperty(value="desiredState") State desiredState, @JsonProperty(value="state") State state, @JsonProperty(value="lastModified") DateTime lastModified, @JsonProperty(value="lastStateChange") DateTime lastStateChange, @JsonProperty(value="availableUpdateTypes") List<UpdateDetails> availableUpdateTypes, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="proposedClusterVersion") Integer proposedClusterVersion, @JsonProperty(value="deployedClusterVersion") Integer deployedClusterVersion, @JsonProperty(value="proposedClusterNodesVersion") Integer proposedClusterNodesVersion, @JsonProperty(value="deployedClusterNodesVersion") Integer deployedClusterNodesVersion, @JsonProperty(value="configServerClusterVersion") Integer configServerClusterVersion, @JsonProperty(value="updateType") UpdateType updateType, @JsonProperty(value="frequentStatusRefreshUntil") DateTime frequentStatusRefreshUntil, @JsonProperty(value="updateState") UpdateState updateState, @JsonProperty(value="lastInstanceHealthCheck") DateTime lastInstanceHealthCheck, @JsonProperty(value="mockEntity") Boolean mockEntity, @JsonProperty(value="notificationCutoff") DateTime notificationCutoff, @JsonProperty(value="clearExistingContextOnMerge") Boolean clearExistingContextOnMerge, @JsonProperty(value="clearExistingUpdateState") Boolean clearExistingUpdateState, @JsonProperty(value="transitionStateChain") List<State> transitionStateChain, @JsonProperty(value="maxSurgeCount") Integer maxSurgeCount) {
        this.key = key;
        this.entityId = entityId;
        this.entityType = entityType;
        this.desiredState = desiredState;
        this.state = state;
        this.lastModified = lastModified;
        this.lastStateChange = lastStateChange;
        this.availableUpdateTypes = availableUpdateTypes != null ? new ArrayList<UpdateDetails>(availableUpdateTypes) : null;
        this.context = context;
        this.proposedClusterVersion = proposedClusterVersion;
        this.deployedClusterVersion = deployedClusterVersion;
        this.proposedClusterNodesVersion = proposedClusterNodesVersion;
        this.deployedClusterNodesVersion = deployedClusterNodesVersion;
        this.configServerClusterVersion = configServerClusterVersion;
        this.updateType = updateType;
        this.frequentStatusRefreshUntil = frequentStatusRefreshUntil;
        this.updateState = updateState;
        this.lastInstanceHealthCheck = lastInstanceHealthCheck;
        this.mockEntity = mockEntity;
        this.notificationCutoff = notificationCutoff;
        this.clearExistingContextOnMerge = clearExistingContextOnMerge;
        this.clearExistingUpdateState = clearExistingUpdateState;
        this.transitionStateChain = transitionStateChain != null ? new ArrayList<State>(transitionStateChain) : null;
        this.maxSurgeCount = maxSurgeCount;
    }

    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    public String getEntityId() {
        return this.entityId;
    }

    @JsonProperty
    public EntityType getEntityType() {
        return this.entityType;
    }

    @JsonProperty
    public State getDesiredState() {
        return this.desiredState;
    }

    @JsonProperty
    public State getState() {
        return this.state;
    }

    @JsonProperty
    public DateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty
    public DateTime getLastStateChange() {
        return this.lastStateChange;
    }

    @JsonProperty
    public List<UpdateDetails> getAvailableUpdateTypes() {
        return this.availableUpdateTypes;
    }

    @JsonProperty
    public Map<String, String> getContext() {
        return this.context;
    }

    @JsonProperty
    public Integer getProposedClusterVersion() {
        return this.proposedClusterVersion;
    }

    @JsonProperty
    public Integer getDeployedClusterVersion() {
        return this.deployedClusterVersion;
    }

    @JsonProperty
    public Integer getProposedClusterNodesVersion() {
        return this.proposedClusterNodesVersion;
    }

    @JsonProperty
    public Integer getDeployedClusterNodesVersion() {
        return this.deployedClusterNodesVersion;
    }

    @JsonProperty
    public Integer getConfigServerClusterVersion() {
        return this.configServerClusterVersion;
    }

    @JsonProperty
    public UpdateType getUpdateType() {
        return this.updateType;
    }

    @JsonProperty
    public DateTime getFrequentStatusRefreshUntil() {
        return this.frequentStatusRefreshUntil;
    }

    @JsonProperty
    public UpdateState getUpdateState() {
        return this.updateState;
    }

    @JsonProperty
    public DateTime getLastInstanceHealthCheck() {
        return this.lastInstanceHealthCheck;
    }

    @JsonProperty(value="mockEntity")
    public Boolean isMockEntity() {
        return this.mockEntity;
    }

    @JsonProperty
    public DateTime getNotificationCutoff() {
        return this.notificationCutoff;
    }

    public Boolean isClearExistingContextOnMerge() {
        return this.clearExistingContextOnMerge;
    }

    public Boolean isClearExistingUpdateState() {
        return this.clearExistingUpdateState;
    }

    @JsonProperty
    public List<State> getTransitionStateChain() {
        return this.transitionStateChain;
    }

    @JsonProperty
    public Integer getMaxSurgeCount() {
        return this.maxSurgeCount;
    }

    public String getRequestId() {
        return this.context == null ? null : this.context.get("requestId");
    }

    public String getParentSpanId() {
        return this.context == null ? null : this.context.get("parentSpanId");
    }

    public String getSpanId() {
        return this.context == null ? null : this.context.get("spanId");
    }

    public String getRequesterId() {
        return this.context == null ? null : this.context.get("requesterId");
    }

    public boolean hasNetworkStack() {
        return false;
    }

    public Class<? extends Annotation> getAnnotatedType() {
        return null;
    }

    public String toString() {
        return new ToStringBuilder(this).append("key", this.key).append("entityId", (Object)this.entityId).append("entityType", (Object)this.entityType).append("desiredState", (Object)this.desiredState).append("state", (Object)this.state).append("lastModified", (Object)this.lastModified).append("lastStateChange", (Object)this.lastStateChange).append("availableUpdateTypes", this.availableUpdateTypes).append("context", this.context).append("proposedClusterVersion", (Object)this.proposedClusterVersion).append("deployedClusterVersion", (Object)this.deployedClusterVersion).append("proposedClusterNodesVersion", (Object)this.proposedClusterNodesVersion).append("deployedClusterNodesVersion", (Object)this.deployedClusterNodesVersion).append("configServerClusterVersion", (Object)this.configServerClusterVersion).append("updateType", (Object)this.updateType).append("frequentStatusRefreshUntil", (Object)this.frequentStatusRefreshUntil).append("updateState", (Object)this.updateState).append("lastInstanceHealthCheck", (Object)this.lastInstanceHealthCheck).append("mockEntity", (Object)this.mockEntity).append("notificationCutoff", (Object)this.notificationCutoff).append("clearExistingContextOnMerge", (Object)this.clearExistingContextOnMerge).append("clearExistingUpdateState", (Object)this.clearExistingUpdateState).append("transitionStateChain", this.transitionStateChain).append("maxSurgeCount", (Object)this.maxSurgeCount).toString();
    }

    public Builder cloner() {
        return Info.builder().withInfo(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<Subclass extends Builder, TypeToBuild extends Info> {
        protected String key;
        protected String entityId;
        protected EntityType entityType;
        protected State desiredState;
        protected State state;
        protected DateTime lastModified;
        protected DateTime lastStateChange;
        protected List<UpdateDetails> availableUpdateTypes;
        protected Map<String, String> context;
        protected Integer proposedClusterVersion;
        protected Integer deployedClusterVersion;
        protected Integer proposedClusterNodesVersion;
        protected Integer deployedClusterNodesVersion;
        protected Integer configServerClusterVersion;
        protected UpdateType updateType;
        protected DateTime frequentStatusRefreshUntil;
        protected UpdateState updateState;
        protected DateTime lastInstanceHealthCheck;
        protected Boolean mockEntity;
        protected DateTime notificationCutoff;
        protected boolean clearExistingContextOnMerge = false;
        protected boolean clearExistingUpdateState = false;
        protected List<State> transitionStateChain;
        protected String requestId;
        protected String parentSpanId;
        protected String spanId;
        protected String requesterId;
        protected Integer maxSurgeCount;

        protected Builder() {
        }

        protected final Subclass getSubclass() {
            return (Subclass)this;
        }

        public TypeToBuild build() {
            this.setContext();
            return (TypeToBuild)new Info(this.key, this.entityId, this.entityType, this.desiredState, this.state, this.lastModified, this.lastStateChange, this.availableUpdateTypes, this.context, this.proposedClusterVersion, this.deployedClusterVersion, this.proposedClusterNodesVersion, this.deployedClusterNodesVersion, this.configServerClusterVersion, this.updateType, this.frequentStatusRefreshUntil, this.updateState, this.lastInstanceHealthCheck, this.mockEntity, this.notificationCutoff, this.clearExistingContextOnMerge, this.clearExistingUpdateState, this.transitionStateChain, this.maxSurgeCount);
        }

        protected void setContext() {
            if (this.context == null) {
                this.context = new HashMap<String, String>();
            }
            if (this.requestId != null) {
                this.context.put("requestId", this.requestId);
            }
            if (this.parentSpanId != null) {
                this.context.put("parentSpanId", this.parentSpanId);
            }
            if (this.spanId != null) {
                this.context.put("spanId", this.spanId);
            }
            if (this.requesterId != null) {
                this.context.put("requesterId", this.requesterId);
            }
        }

        public Subclass withInfo(Info info) {
            return this.withInfo(info, false);
        }

        public Subclass withInfo(Info info, boolean merge) {
            if (info == null) {
                return this.getSubclass();
            }
            if (info.key != null) {
                this.key = info.key;
            }
            if (info.entityId != null) {
                this.entityId = info.entityId;
            }
            if (info.entityType != null) {
                this.entityType = info.entityType;
            }
            if (info.desiredState != null) {
                this.desiredState = info.desiredState;
            }
            if (info.state != null) {
                this.state = info.state;
            }
            if (info.lastModified != null) {
                this.lastModified = info.lastModified;
            }
            if (info.lastStateChange != null) {
                this.lastStateChange = info.lastStateChange;
            }
            if (info.availableUpdateTypes != null) {
                this.availableUpdateTypes = info.availableUpdateTypes;
            }
            if (merge) {
                if (info.clearExistingContextOnMerge.booleanValue()) {
                    this.context = info.context;
                } else {
                    if (this.context == null) {
                        this.context = new HashMap<String, String>();
                    }
                    if (info.context != null) {
                        this.context.putAll(info.context);
                    }
                }
            } else if (info.context != null) {
                this.context = info.context;
            }
            if (info.proposedClusterVersion != null) {
                this.proposedClusterVersion = info.proposedClusterVersion;
            }
            if (info.deployedClusterVersion != null) {
                this.deployedClusterVersion = info.deployedClusterVersion;
            }
            if (info.proposedClusterNodesVersion != null) {
                this.proposedClusterNodesVersion = info.proposedClusterNodesVersion;
            }
            if (info.deployedClusterNodesVersion != null) {
                this.deployedClusterNodesVersion = info.deployedClusterNodesVersion;
            }
            if (info.configServerClusterVersion != null) {
                this.configServerClusterVersion = info.configServerClusterVersion;
            }
            if (info.updateType != null) {
                this.updateType = info.updateType;
            }
            if (info.maxSurgeCount != null) {
                this.maxSurgeCount = info.maxSurgeCount;
            }
            if (info.frequentStatusRefreshUntil != null) {
                this.frequentStatusRefreshUntil = info.frequentStatusRefreshUntil;
            }
            if (merge) {
                this.updateState = this.updateState == null || info.clearExistingUpdateState != false ? info.updateState : this.updateState.merge(info.updateState);
            } else if (info.updateState != null) {
                this.updateState = info.updateState;
            }
            if (info.lastInstanceHealthCheck != null) {
                this.lastInstanceHealthCheck = info.lastInstanceHealthCheck;
            }
            if (info.mockEntity != null) {
                this.mockEntity = info.mockEntity;
            }
            if (info.notificationCutoff != null) {
                this.notificationCutoff = info.notificationCutoff;
            }
            if (info.transitionStateChain != null) {
                this.transitionStateChain = info.transitionStateChain;
            }
            if (!merge && info.clearExistingContextOnMerge != null) {
                this.clearExistingContextOnMerge = info.clearExistingContextOnMerge;
            }
            if (!merge && info.clearExistingUpdateState != null) {
                this.clearExistingUpdateState = info.clearExistingUpdateState;
            }
            return this.getSubclass();
        }

        public Subclass withKey(String key) {
            this.key = key;
            return this.getSubclass();
        }

        public Subclass withEntityId(String entityId) {
            this.entityId = entityId;
            return this.getSubclass();
        }

        public Subclass withEntityType(EntityType entityType) {
            this.entityType = entityType;
            return this.getSubclass();
        }

        public Subclass withDesiredState(State desiredState) {
            this.desiredState = desiredState;
            return this.getSubclass();
        }

        public Subclass withState(State state) {
            this.state = state;
            return this.getSubclass();
        }

        public Subclass withLastModified(DateTime lastModified) {
            this.lastModified = lastModified;
            return this.getSubclass();
        }

        public Subclass withLastStateChange(DateTime lastStateChange) {
            this.lastStateChange = lastStateChange;
            return this.getSubclass();
        }

        public Subclass withAvailableUpdateTypes(List<UpdateDetails> availableUpdateTypes) {
            this.availableUpdateTypes = availableUpdateTypes;
            return this.getSubclass();
        }

        public Subclass withContext(Map<String, String> context) {
            this.context = context;
            return this.getSubclass();
        }

        public Subclass withRequestId(String requestId) {
            this.requestId = requestId;
            return this.getSubclass();
        }

        public Subclass withParentSpanId(String parentSpanId) {
            this.parentSpanId = parentSpanId;
            return this.getSubclass();
        }

        public Subclass withSpanId(String spanId) {
            this.spanId = spanId;
            return this.getSubclass();
        }

        public Subclass withRequesterId(String requesterId) {
            this.requesterId = requesterId;
            return this.getSubclass();
        }

        public Subclass withThreadLocalContext() {
            this.requestId = ThreadLocalContext.getRequestId();
            this.parentSpanId = ThreadLocalContext.getParentSpanId();
            this.spanId = ThreadLocalContext.getSpanId();
            this.requesterId = ThreadLocalContext.getPrincipal() != null ? ThreadLocalContext.getPrincipal().getDetailedUserId() : null;
            this.context = ThreadLocalContext.getUserContext();
            return this.getSubclass();
        }

        public Subclass withProposedClusterVersion(Integer proposedClusterVersion) {
            this.proposedClusterVersion = proposedClusterVersion;
            return this.getSubclass();
        }

        public Subclass withDeployedClusterVersion(Integer deployedClusterVersion) {
            this.deployedClusterVersion = deployedClusterVersion;
            return this.getSubclass();
        }

        public Subclass withProposedClusterNodesVersion(Integer proposedClusterNodesVersion) {
            this.proposedClusterNodesVersion = proposedClusterNodesVersion;
            return this.getSubclass();
        }

        public Subclass withDeployedClusterNodesVersion(Integer deployedClusterNodesVersion) {
            this.deployedClusterNodesVersion = deployedClusterNodesVersion;
            return this.getSubclass();
        }

        public Subclass withConfigServerClusterVersion(Integer configServerClusterVersion) {
            this.configServerClusterVersion = configServerClusterVersion;
            return this.getSubclass();
        }

        public Subclass withUpdateType(UpdateType updateType) {
            this.updateType = updateType;
            return this.getSubclass();
        }

        public Subclass withFrequentStatusRefreshUntil(DateTime frequentStatusRefreshUntil) {
            this.frequentStatusRefreshUntil = frequentStatusRefreshUntil;
            return this.getSubclass();
        }

        public Subclass withUpdateState(UpdateState updateState) {
            this.updateState = updateState;
            return this.getSubclass();
        }

        public Subclass withLastInstanceHealthCheck(DateTime lastInstanceHealthCheck) {
            this.lastInstanceHealthCheck = lastInstanceHealthCheck;
            return this.getSubclass();
        }

        public Subclass withMockEntity(Boolean mockEntity) {
            this.mockEntity = mockEntity;
            return this.getSubclass();
        }

        public Subclass withNotificationCutoff(DateTime notificationCutoff) {
            this.notificationCutoff = notificationCutoff;
            return this.getSubclass();
        }

        public Subclass withTransitionStateChain(List<State> transitionStateChain) {
            this.transitionStateChain = transitionStateChain;
            return this.getSubclass();
        }

        public Subclass withMaxSurgeCount(Integer maxSurgeCount) {
            this.maxSurgeCount = maxSurgeCount;
            return this.getSubclass();
        }

        public Subclass clearExistingContext() {
            this.clearExistingContextOnMerge = true;
            return this.getSubclass();
        }

        public Subclass clearExistingUpdateState() {
            this.clearExistingUpdateState = true;
            return this.getSubclass();
        }

        public Subclass removeClearedFields() {
            if ("".equals(this.key)) {
                this.key = null;
            }
            if ("".equals(this.entityId)) {
                this.entityId = null;
            }
            if (State.CLEAR_FIELD.equals((Object)this.desiredState)) {
                this.desiredState = null;
            }
            if (State.CLEAR_FIELD.equals((Object)this.state)) {
                this.state = null;
            }
            if (Constants.CLEAR_FIELD_INT.equals(this.proposedClusterVersion)) {
                this.proposedClusterVersion = null;
            }
            if (Constants.CLEAR_FIELD_INT.equals(this.deployedClusterVersion)) {
                this.deployedClusterVersion = null;
            }
            if (Constants.CLEAR_FIELD_INT.equals(this.proposedClusterNodesVersion)) {
                this.proposedClusterNodesVersion = null;
            }
            if (Constants.CLEAR_FIELD_INT.equals(this.deployedClusterNodesVersion)) {
                this.deployedClusterNodesVersion = null;
            }
            if (Constants.CLEAR_FIELD_INT.equals(this.configServerClusterVersion)) {
                this.configServerClusterVersion = null;
            }
            if (UpdateType.NOT_SET.equals((Object)this.updateType)) {
                this.updateType = null;
            }
            if (this.updateState != null) {
                this.updateState = this.updateState.removeClearedFields();
            }
            return this.getSubclass();
        }

        public Subclass stripInternalFields() {
            this.key = null;
            this.entityId = null;
            this.entityType = null;
            if (this.state == null || this.desiredState == null || !State.UPDATING.equals((Object)this.state.getExternalState(this.desiredState))) {
                this.updateType = null;
            }
            this.useExternalState();
            this.lastModified = null;
            this.context = null;
            if (this.updateState != null) {
                this.updateState = this.updateState.stripInternalFields();
            }
            this.notificationCutoff = null;
            return this.getSubclass();
        }

        public Subclass useExternalState() {
            if (this.state != null) {
                this.state = this.state.getExternalState(this.desiredState);
            }
            if (this.desiredState != null) {
                this.desiredState = this.desiredState.getExternalState(this.desiredState);
            }
            return this.getSubclass();
        }
    }
}

